//
// ImageButtonCell.h
//
// $Id: //poco/Main/WebWidgets/include/Poco/WebWidgets/ImageButtonCell.h#3 $
//
// Library: WebWidgets
// Package: Controls
// Module:  ImageButtonCell
//
// Definition of the ImageButtonCell class.
//
// Copyright (c) 2008, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#ifndef WebWidgets_ImageButtonCell_INCLUDED
#define WebWidgets_ImageButtonCell_INCLUDED


#include "Poco/WebWidgets/ButtonCell.h"
#include "Poco/WebWidgets/Image.h"
#include "Poco/URI.h"


namespace Poco {
namespace WebWidgets {


class WebWidgets_API ImageButtonCell: public ButtonCell
	/// A Cell for a plain old ImageButton.
{
public:
	typedef Poco::AutoPtr<ImageButtonCell> Ptr;

	ImageButtonCell(View* pOwner, Image::Ptr img);
		/// Creates a ImageButtonCell.

	void setImage(Image::Ptr img);
		/// Set the url to the image

	Image::Ptr getImage() const;
		/// Get the url to the image

	void setShowText(bool val);
		/// If set to true it will show an optional text on top of the image

	bool getShowText() const;
		/// Returns true if it will show an optional text on top of the image

	const Poco::URI& getImageURI() const;
		/// Returns the url of the image

protected:
	~ImageButtonCell();
		/// Destroys the ImageButtonCell.

private:
	Image::Ptr _ptrImg;
	bool  _showText;
};


inline void ImageButtonCell::setImage(Image::Ptr img)
{
	_ptrImg = img;
}


inline Image::Ptr ImageButtonCell::getImage() const
{
	return _ptrImg;
}


inline void ImageButtonCell::setShowText(bool val)
{
	_showText = val;
}


inline bool ImageButtonCell::getShowText() const
{
	return _showText;
}



} } // namespace Poco::WebWidgets


#endif // WebWidgets_ImageButtonCell_INCLUDED
