//
// Image.h
//
// $Id: //poco/Main/WebWidgets/include/Poco/WebWidgets/Image.h#5 $
//
// Library: WebWidgets
// Package: Views
// Module:  Image
//
// Definition of the Image class.
//
// Copyright (c) 2007, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#ifndef WebWidgets_Image_INCLUDED
#define WebWidgets_Image_INCLUDED


#include "Poco/WebWidgets/View.h"
#include "Poco/URI.h"


namespace Poco {
namespace WebWidgets {


class WebWidgets_API Image: public View
	/// TODO: Describe class Image...
{
public:
	typedef Poco::AutoPtr<Image> Ptr;

	Image(const Poco::URI& uri);
		/// Creates an anonymous Image.

	Image(const std::string& name, const Poco::URI& uri);
		/// Creates a Image with the given name.

	void setURI(const Poco::URI& uri);
		/// Sets the url of the image file

	const Poco::URI& getURI() const;
		/// Returns the URL of the image file

	// View
	void setText(const std::string& text);

	std::string getText() const;

	void setToolTip(const std::string& text);
		/// Sets the tooltip text for this View.

	std::string getToolTip() const;
		///Returns the tooltip text

protected:
	Image(const std::string& name, const Poco::URI& uri, const std::type_info& type);
		/// Creates a Image and assigns it the given name.

	Image(const Poco::URI& uri, const std::type_info& type);
		/// Creates a Image.

	~Image();
		/// Destroys the Image.

private:
	std::string _text;
	Poco::URI   _uri;
	std::string _toolTip;
};


//
// inlines
//

inline void Image::setText(const std::string& text)
{
	_text = text;
}


inline std::string Image::getText() const
{
	return _text;
}


inline void Image::setURI(const Poco::URI& uri)
{
	_uri = uri;
}


inline const Poco::URI& Image::getURI() const
{
	return _uri;
}


inline void Image::setToolTip(const std::string& text)
{
	_toolTip = text;
}


inline std::string Image::getToolTip() const
{
	return _toolTip;
}


} } // namespace Poco::WebWidgets


#endif // WebWidgets_Image_INCLUDED
