//
// DateFieldCell.h
//
// $Id: //poco/Main/WebWidgets/include/Poco/WebWidgets/DateFieldCell.h#3 $
//
// Library: WebWidgets
// Package: Controls
// Module:  DateFieldCell
//
// Definition of the DateFieldCell class.
//
// Copyright (c) 2007, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#ifndef WebWidgets_DateFieldCell_INCLUDED
#define WebWidgets_DateFieldCell_INCLUDED


#include "Poco/WebWidgets/TextFieldCell.h"
#include "Poco/DateTime.h"
#include "Poco/Any.h"


namespace Poco {
namespace WebWidgets {


class WebWidgets_API DateFieldCell: public TextFieldCell
	/// A cell for a DateField
{
public:
	typedef Poco::AutoPtr<DateFieldCell> Ptr;

	DateFieldCell(View* pOwner);
		/// Creates the DateFieldCell with a simple Y-m-d format

	virtual ~DateFieldCell();
		/// Destroys the DateFieldCell.

	void setFormat(const std::string& dateFormat);
		/// Sets a format string as defined in Poco::DateFormat, Poco::DateFormatter

	const std::string& getFormat() const;
		/// Returns the format

	void setDate(const Poco::DateTime& dt);
		/// Sets the date

	const Poco::DateTime& getDate() const;
		/// returns the date if set, otherwise an exception, use getValue().empty() to check if it is valid

	bool serializeJSON(std::ostream& out, const std::string& name);
	
private:
	std::string _format;
};


inline const std::string& DateFieldCell::getFormat() const
{
	return _format;
}


inline void DateFieldCell::setDate(const Poco::DateTime& dt)
{
	setValue(dt);
}


inline const Poco::DateTime& DateFieldCell::getDate() const
{
	return Poco::RefAnyCast<Poco::DateTime>(getValue());
}


} } // namespace Poco::WebWidgets


#endif // WebWidgets_DateFieldCell_INCLUDED
