//
// DataRetriever.h
//
// $Id: //poco/Main/WebWidgets/include/Poco/WebWidgets/DataRetriever.h#1 $
//
// Library: WebWidgets
// Package: Core
// Module:  DataRetriever
//
// Definition of the DataRetriever class.
//
// Copyright (c) 2008, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#ifndef WebWidgets_DataRetriever_INCLUDED
#define WebWidgets_DataRetriever_INCLUDED


#include "Poco/WebWidgets/WebWidgets.h"
#include "Poco/Net/HTTPRequestHandler.h"
#include "Poco/Path.h"
#include "Poco/File.h"
#include <map>


namespace Poco {

	class Logger;

namespace WebWidgets {


class WebWidgets_API DataRetriever: public Poco::Net::HTTPRequestHandler
	/// DataRetriever class handles file transfers
{
public:
	static const std::string INDEX_HTM;
	static const std::string INDEX_HTML;
	static const std::string MSG_LISTING_NOT_ALLOWED;
	static const std::string MSG_NOT_FOUND;
	typedef std::map<std::string, Poco::Path> Aliases;
		/// Maps a server path to a local file system path

	DataRetriever(const DataRetriever::Aliases& alias, Poco::Logger* pLogger = 0);
		/// Creates the DataRetriever. We only support simple alias resolution, ie a server path can consist only of one directory!
		/// alias is not copied, only stored as reference! Must be stored permanently outside this class.
	/// The alias must contain an entry for an empty path: the root dir (ie. alias.insert(std::make_pair("", Poco::Path(...))))
		/// Example:
		///    /    -> c:\\data
		///    /gif -> p:\\data\gif
		/// Illegal (nested path):
		///    /gif/data -> p:\\data\gif

	~DataRetriever();
		/// Destroys the DataRetriever.

	void handleRequest(Poco::Net::HTTPServerRequest& request, Poco::Net::HTTPServerResponse& response);

	static void sendFile(const std::string& path, Poco::Net::HTTPServerResponse& response);

private:
	std::string resolveAliases(const std::string& path);

	void handleBrowsingNotAllowed(Poco::Net::HTTPServerResponse& response);
	void handleNotFound(Poco::Net::HTTPServerResponse& response);

	static std::map<std::string, std::string> initExtensions();
private:
	const Aliases& _aliases;
	Poco::Logger*  _pLogger;
	static std::map<std::string, std::string> EXTENSIONMAPPING;
		/// Maps file extensions to content/type
};


} } // namespace Poco::WebWidgets


#endif // Server_DataRetriever_INCLUDED
