//
// ContainerView.h
//
// $Id: //poco/Main/WebWidgets/include/Poco/WebWidgets/ContainerView.h#4 $
//
// Library: WebWidgets
// Package: Views
// Module:  ContainerView
//
// Definition of the ContainerView class.
//
// Copyright (c) 2008, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#ifndef WebWidgets_ContainerView_INCLUDED
#define WebWidgets_ContainerView_INCLUDED


#include "Poco/WebWidgets/View.h"
#include <vector>


namespace Poco {
namespace WebWidgets {


class WebWidgets_API ContainerView: public View
	/// ContainerView is a base class for View classes containing
	/// or managing View instances.
{
public:
	typedef Poco::AutoPtr<ContainerView> Ptr;
	typedef std::vector<View::Ptr> ViewVec;
	typedef ViewVec::const_iterator ConstIterator;
	typedef ViewVec::iterator Iterator;
	
	ContainerView();
		/// Creates an anonymous ContainerView.
		
	ContainerView(const std::string& name);
		/// Creates a ContainerView with the given name.
	
	virtual void add(View::Ptr pView);
		/// Adds a View to the ContainerView.
		
	virtual void remove(View::Ptr pView);
		/// Removes the given view from the ContainerView.
		
	bool empty() const;
		/// Returns true iff the ContainerView does not contain any views.
		
	std::size_t size() const;
		/// Returns the number of Views in this ContainerView.
		
	ConstIterator begin() const;
	ConstIterator end() const;
	Iterator begin();
	Iterator end();

	View::Ptr findChild(const std::string& name) const;

	
protected:
	ContainerView(const std::string& name, const std::type_info& type);
		/// Creates a ContainerView and assigns it the given name.
		
	ContainerView(const std::type_info& type);
		/// Creates a ContainerView.
		
	~ContainerView();
		/// Destroys the ContainerView.

	ViewVec& views();
		/// Returns the views

	const ViewVec& views() const;
		/// Returns the views
		
private:
	ViewVec _views;
};


//
// inlines
//
inline ContainerView::ConstIterator ContainerView::begin() const
{
	return _views.begin();
}


inline ContainerView::ConstIterator ContainerView::end() const
{
	return _views.end();
}


inline ContainerView::Iterator ContainerView::begin()
{
	return _views.begin();
}


inline ContainerView::Iterator ContainerView::end()
{
	return _views.end();
}


inline bool ContainerView::empty() const
{
	return _views.empty();
}


inline std::size_t ContainerView::size() const
{
	return _views.size();
}


inline ContainerView::ViewVec& ContainerView::views()
{
	return _views;
}


inline const ContainerView::ViewVec& ContainerView::views() const
{
	return _views;
}


} } // namespace Poco::WebWidgets


#endif // WebWidgets_ContainerView_INCLUDED
