//
// ComboBoxCell.h
//
// $Id: //poco/Main/template/class.h#8 $
//
// Library: WebWidgets
// Package: Controls
// Module:  ComboBoxCell
//
// Definition of the ComboBoxCell class.
//
// Copyright (c) 2007, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#ifndef WebWidgets_ComboBoxCell_INCLUDED
#define WebWidgets_ComboBoxCell_INCLUDED


#include "Poco/WebWidgets/TextFieldCell.h"
#include "Poco/WebWidgets/Delegate.h"
#include "Poco/FIFOEvent.h"
#include "Poco/Net/HTTPServerResponse.h"
#include <vector>


namespace Poco {
namespace WebWidgets {


class WebWidgets_API ComboBoxCell: public TextFieldCell
	/// A cell for a ComboBox
{
public:
	typedef Poco::AutoPtr<ComboBoxCell> Ptr;
	typedef std::pair<Poco::Any, Poco::Any> OldNewValue;
	
	
	static const std::string EV_SELECTED;
	static const std::string EV_BEFORESELECT;
	static const std::string EV_LOAD;
	static const std::string EV_AFTERLOAD;
	static const std::string FIELD_VAL;
	
	FIFOEvent<const Poco::Any>   beforeSelect; /// thrown before a new element is selected
	FIFOEvent<const OldNewValue> selected; /// thrown after a new element is selected
	
	Delegate                     afterLoad;
	
	FIFOEvent<Poco::Net::HTTPServerResponse*> beforeLoad; /// thrown whenever a load is requested

	ComboBoxCell(View* pOwner);
		/// Creates the ComboBoxCell.

	std::vector<Any>::const_iterator begin() const;
		/// ConstIterator to all elements

	std::vector<Any>::iterator begin();
		/// Iterator to all elements

	std::vector<Any>::const_iterator end() const;
		/// ConstIterator to all elements

	std::vector<Any>::iterator end();
		/// Iterator to all elements
		
	template <typename T>	
	void setElements(const std::vector<T>& elems)
		/// Initializes the combo box cell with the provided elements
	{
		std::vector<Any> result;
		typename std::vector<T>::const_iterator it = elems.begin();
		for (; it != elems.end(); ++it)
			result.push_back(*it);
		setElements(result);
	}	

	void setElements(const std::vector<Any>& elems);
		/// Initializes the combo box with the provided elements

	const std::vector<Any>& getElements() const;
		/// Returns all elements

	void insert(const Any& elem);
		/// Add a single element to the collection

	void erase(const Any& elem);
		/// Removes a single element from the collection

	void setSelected(const Any& elem);
		/// Selects the element. 

	bool hasSelected() const;
		/// Returns true if a selected element exists

	const Any& getSelected() const;
		/// Returns the selected element, excpetion if none was selected
		
	void handleForm(const std::string& field, const std::string& value);
	
	void handleAjaxRequest(const Poco::Net::NameValueCollection& args, Poco::Net::HTTPServerResponse& response);
		/// Handles a complete AJAX request submitted by the client.
		
	bool serializeJSON(std::ostream& out, const std::string& name);	
		
protected:
	~ComboBoxCell();
		/// Destroys the ComboBoxCell.

private:
	std::vector<Any> _elements;
};


inline bool ComboBoxCell::hasSelected() const
{
	return !getValue().empty();
}


inline std::vector<Any>::const_iterator ComboBoxCell::begin() const
{
	return _elements.begin();
}


inline std::vector<Any>::iterator ComboBoxCell::begin()
{
	return _elements.begin();
}


inline std::vector<Any>::const_iterator ComboBoxCell::end() const
{
	return _elements.end();
}


inline std::vector<Any>::iterator ComboBoxCell::end()
{
	return _elements.end();
}


inline void ComboBoxCell::setElements(const std::vector<Any>& elems)
	/// Initializes the combo box with the provided elements
{
	_elements = elems;
}


inline const std::vector<Any>& ComboBoxCell::getElements() const
{
	return _elements;
}


inline void ComboBoxCell::insert(const Any& elem)
{
	_elements.push_back(elem);
}


inline const Any& ComboBoxCell::getSelected() const
	/// Returns the selected element, excpetion if none was selected
{
	return getValue();
}


} } // namespace Poco::WebWidgets


#endif // WebWidgets_ComboBoxCell_INCLUDED
