//
// Color.h
//
// $Id: //poco/Main/WebWidgets/include/Poco/WebWidgets/Color.h#2 $
//
// Library: WebWidgets
// Package: Core
// Module:  Color
//
// Definition of the Color class.
//
// Copyright (c) 2008, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#ifndef WebWidgets_Color_INCLUDED
#define WebWidgets_Color_INCLUDED


#include "Poco/WebWidgets/WebWidgets.h"


namespace Poco {
namespace WebWidgets {


class WebWidgets_API Color
	/// A Color object contains a color specification
	/// in the RGB color space.
{
public:
	Color();
		/// Creates a Color representing black (all values zero).
		
	Color(Poco::UInt8 red, Poco::UInt8 green, Poco::UInt8 blue);
		/// Creates a Color.
		
	Color(const std::string& htmlColor);
		/// Creates a Color using the given HTML color code (#xxx or #xxxxxx).
		
	Color(const Color& color);
		/// Creates a Color by copying another one.
				
	~Color();
		/// Destroys the Color.
		
	void swap(Color& color);
		/// Swaps the Color with another one.
		
	Color& operator = (const Color& color);
		/// Assignment operator.
		
	Poco::UInt8 red() const;
		/// Returns the value of the red component.
		
	Poco::UInt8 green() const;
		/// Returns the value of the green component.
		
	Poco::UInt8 blue() const;
		/// Returns the value of the blue component.
		
	std::string asHTML() const;
		/// Returns the HTML color string for the color (#xxxxxx).
		
private:
	struct Predefined
	{
		const char* name;
		Poco::UInt8 red;
		Poco::UInt8 green;
		Poco::UInt8 blue;
	};
	Poco::UInt8 _red;
	Poco::UInt8 _green;
	Poco::UInt8 _blue;
	Poco::UInt8 _alpha; // currently unused
	
	enum
	{
		PREDEFINED_COUNT = 16,
	};
	static const Predefined predefined[PREDEFINED_COUNT];
};


//
// inlines
//
inline Poco::UInt8 Color::red() const
{
	return _red;
}


inline Poco::UInt8 Color::green() const
{
	return _green;
}


inline Poco::UInt8 Color::blue() const
{
	return _blue;
}


} } // namespace Poco::WebWidgets


#endif // WebWidgets_Color_INCLUDED
