//
// Collapsible.h
//
// $Id: //poco/Main/WebWidgets/include/Poco/WebWidgets/Collapsible.h#1 $
//
// Library: WebWidgets
// Package: Views
// Module:  Collapsible
//
// Definition of the Collapsible class.
//
// Copyright (c) 2007, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#ifndef WebWidgets_Collapsible_INCLUDED
#define WebWidgets_Collapsible_INCLUDED


#include "Poco/WebWidgets/Frame.h"


namespace Poco {
namespace WebWidgets {


class WebWidgets_API Collapsible: public Frame
	/// Class Collapsible is a Frame that can be minimized/maximized. Per default it starts out maximized.
{
public:
	typedef Poco::AutoPtr<Collapsible> Ptr;

	Collapsible();
		/// Creates an unnamed Collapsible.

	Collapsible(const std::string& name);
		/// Creates the Collapsible.

	Collapsible(View::Ptr pChild);
		/// Creates an unnamed Collapsible.

	Collapsible(const std::string& name, View::Ptr pChild);
		/// Creates the Collapsible.

	void setCollapse(bool val);
		/// Sets if the frame should be collapsed

	bool getCollapse() const;
		/// Returns if the frame should be collapsed

protected:
	~Collapsible();
		/// Destroy the Collapsible

private:
	bool _collapse;
};

//
// Inlines
//

inline void Collapsible::setCollapse(bool val)
{
	_collapse = val;
}


inline bool Collapsible::getCollapse() const
{
	return _collapse;
}


} } // namespace Poco::WebWidgets


#endif // WebWidgets_Collapsible_INCLUDED
