//
// CheckButton.h
//
// $Id: //poco/Main/WebWidgets/include/Poco/WebWidgets/CheckButton.h#3 $
//
// Library: WebWidgets
// Package: ToggleButtons
// Module:  CheckButton
//
// Definition of the CheckButton class.
//
// Copyright (c) 2007, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#ifndef WebWidgets_CheckButton_INCLUDED
#define WebWidgets_CheckButton_INCLUDED


#include "Poco/WebWidgets/ToggleButton.h"


namespace Poco {
namespace WebWidgets {


class WebWidgets_API CheckButton: public ToggleButton
	/// A CheckButton is a button that can switch between two states
{
public:
	typedef Poco::AutoPtr<CheckButton> Ptr;

	CheckButton(const std::string& name, const std::string& label, bool isChecked);
		/// Creates a TextField with the given name.

	CheckButton();
		/// Creates an anonymous TextField.

protected:
	CheckButton(const std::string& name, const std::string& label, bool isChecked, const std::type_info& type);
		/// Creates a CheckButton and assigns it the given name.

	CheckButton(const std::type_info& type);
		/// Creates a CheckButton.

	CheckButton(const std::string& name, const std::string& label, bool isChecked, const std::type_info& type, Cell::Ptr ptrCell);
		/// Creates a CheckButton and assigns it the given name.

	CheckButton(const std::type_info& type, Cell::Ptr ptrCell);
		/// Creates a CheckButton.

	~CheckButton();
		/// Destroys the CheckButton.

	void init();
		/// Common init code for all ctors.

	void init(Cell::Ptr pCell);
		/// Common init code for all ctors.
};


} } // namespace Poco::WebWidgets


#endif // WebWidgets_CheckButton_INCLUDED
