//
// ToggleButtonCellRenderer.cpp
//
// $Id: //poco/Main/WebWidgets/ExtJS/src/ToggleButtonCellRenderer.cpp#4 $
//
// Library: ExtJS
// Package: Core
// Module:  ToggleButtonCellRenderer
//
// Copyright (c) 2007, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#include "Poco/WebWidgets/ExtJS/ToggleButtonCellRenderer.h"
#include "Poco/WebWidgets/ExtJS/FormRenderer.h"
#include "Poco/WebWidgets/ExtJS/Utility.h"
#include "Poco/WebWidgets/WebApplication.h"
#include "Poco/WebWidgets/ToggleButtonCell.h"
#include "Poco/WebWidgets/ToggleButton.h"
#include "Poco/WebWidgets/RequestHandler.h"
#include "Poco/NumberFormatter.h"


namespace Poco {
namespace WebWidgets {
namespace ExtJS {


const std::string ToggleButtonCellRenderer::EV_CHECKED("check");

ToggleButtonCellRenderer::ToggleButtonCellRenderer()
{
}


ToggleButtonCellRenderer::~ToggleButtonCellRenderer()
{
}


void ToggleButtonCellRenderer::renderBody(const Renderable* pRenderable, const RenderContext& context, std::ostream& ostr)
{
}


void ToggleButtonCellRenderer::renderProperties(const ToggleButtonCell* pToggleButtonCell, std::ostream& ostr)
{
	View* pOwner = pToggleButtonCell->getOwner();
	ToggleButton* pButton = dynamic_cast<ToggleButton*>(pOwner);
	if (!pToggleButtonCell->getLabel().empty())
		ostr << "boxLabel:'" << Utility::safe(pToggleButtonCell->getLabel()) << "',";
	ostr << "checked:" << (pToggleButtonCell->isChecked()?"true":"false") << ",";
	if (!pToggleButtonCell->isEditable())
		ostr << "readOnly:true,";
	if (pOwner->hasPosition())
		ostr << "x:" << pOwner->getPosition().posX << ",y:" << pOwner->getPosition().posY << ",";
		
	Utility::writeCellProperties(pToggleButtonCell, ostr);
	
	//tooltip is not supported by togglebutton
	std::string tooltip (pToggleButtonCell->getToolTip());
	
	
		
	if (!tooltip.empty() || (pButton && pButton->checked.hasJavaScriptCode()))
	{
		ostr << ",listeners:{";
		bool comma = false;
		if (!tooltip.empty())
		{
			comma = true;
			ostr << "render:function(c){c.getEl().dom.qtip='" << Utility::safe(tooltip) << "'; c.getEl().dom.qclass = 'x-form-tip';}";
		}
		if (pButton && pButton->checked.hasJavaScriptCode())
		{
			if (comma)
				ostr << ",";
			Utility::writeJSEvent(ostr, EV_CHECKED, pButton->checked, &ToggleButtonCellRenderer::createCheckedServerCallback, pButton);
		}
		
		
		ostr << "}"; // close listeners
	}
	
	if (pToggleButtonCell->getOwner() && !pToggleButtonCell->getOwner()->getName().empty())
	{
		WebApplication::instance().registerFormProcessor(pToggleButtonCell->getOwner()->getName(), const_cast<ToggleButtonCell*>(pToggleButtonCell));
	}
	if (pButton)
	{
		WebApplication::instance().registerAjaxProcessor(Poco::NumberFormatter::format(pButton->id()), const_cast<ToggleButtonCell*>(pToggleButtonCell));
	}
}


Poco::WebWidgets::JSDelegate ToggleButtonCellRenderer::createCheckedServerCallback(const ToggleButton* pButton)
{
	// check : ( Ext.form.Checkbox this, Boolean checked ) 
	static const std::string signature("function(box, bChecked)");
	std::map<std::string, std::string> addParams;
	addParams.insert(std::make_pair(ToggleButtonCell::FIELD_VAL, "+(bChecked?'true':'false')"));
	addParams.insert(std::make_pair(RequestHandler::KEY_EVID, ToggleButtonCell::EV_CHECKED));
	return Utility::createServerCallback(signature, addParams, pButton->id(), pButton->checked.getOnSuccess(), pButton->checked.getOnFailure());
}


} } } // namespace Poco::WebWidgets::ExtJS
