//
// TextEditCellRenderer.cpp
//
// $Id: //poco/Main/WebWidgets/ExtJS/src/TextEditCellRenderer.cpp#3 $
//
// Library: ExtJS
// Package: Core
// Module:  TextEditCellRenderer
//
// Copyright (c) 2007, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#include "Poco/WebWidgets/ExtJS/TextEditCellRenderer.h"
#include "Poco/WebWidgets/ExtJS/Utility.h"
#include "Poco/WebWidgets/ExtJS/FormRenderer.h"
#include "Poco/WebWidgets/TextEditCell.h"
#include "Poco/WebWidgets/Control.h"
#include "Poco/WebWidgets/Form.h"
#include "Poco/WebWidgets/WebApplication.h"


namespace Poco {
namespace WebWidgets {
namespace ExtJS {


TextEditCellRenderer::TextEditCellRenderer()
{
}


TextEditCellRenderer::~TextEditCellRenderer()
{
}


void TextEditCellRenderer::renderHead(const Renderable* pRenderable, const RenderContext& context, std::ostream& ostr)
{
	poco_assert_dbg (pRenderable != 0);
	poco_assert_dbg (pRenderable->type() == typeid(Poco::WebWidgets::TextEditCell));
	const TextEditCell* pCell = static_cast<const Poco::WebWidgets::TextEditCell*>(pRenderable);

	ostr << "new Ext.form.TextArea({";

	TextEditCellRenderer::writeCellProperties(pCell, ostr);
	ostr << "})";
	if (pCell->getOwner() && !pCell->getOwner()->getName().empty())
	{
		WebApplication::instance().registerFormProcessor(pCell->getOwner()->getName(), const_cast<TextEditCell*>(pCell));
	}
}


void TextEditCellRenderer::renderBody(const Renderable* pRenderable, const RenderContext& context, std::ostream& ostr)
{
}


void TextEditCellRenderer::writeCellProperties(const TextEditCell* pCell, std::ostream& ostr, bool writeValue)
{
	Utility::writeCellProperties(pCell, ostr);

	if (writeValue&& !pCell->getValue().empty())
	{
		ostr << ", value:'" << Utility::safe(pCell->getString()) << "'";
	}
	
	if (!pCell->isEditable())
		ostr << ", readOnly:true";
	if (pCell->getHeightInPixel() > 0)
		ostr << ", height:" << pCell->getHeightInPixel();
	if (pCell->getGrow())
		ostr << ", grow:true";

	if (!pCell->getPlaceHolder().empty())
		ostr << ", emptyText:'" << Utility::safe(pCell->getPlaceHolder()) << "'";

	const View* pOwner = pCell->getOwner();
	poco_check_ptr (pOwner);
	if (pOwner->hasPosition())
		ostr << ",x:" << pOwner->getPosition().posX << ",y:" << pOwner->getPosition().posY;
		
	//tooltip is not supported by textEdit, add listeners
	std::string tooltip (pCell->getToolTip());
	if (!tooltip.empty())
		ostr << ", listeners: {render: function(c) {Ext.QuickTips.register({target: c.getEl(),text: '" << Utility::safe(tooltip) << "'});}}";
}


} } } // namespace Poco::WebWidgets::ExtJS
