//
// ListBoxCellRenderer.cpp
//
// $Id: //poco/Main/WebWidgets/ExtJS/src/ListBoxCellRenderer.cpp#1 $
//
// Library: ExtJS
// Package: Core
// Module:  ListBoxCellRenderer
//
// Copyright (c) 2007, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#include "Poco/WebWidgets/ExtJS/ListBoxCellRenderer.h"
#include "Poco/WebWidgets/ExtJS/FormRenderer.h"
#include "Poco/WebWidgets/ExtJS/TableRenderer.h"
#include "Poco/WebWidgets/ExtJS/Utility.h"
#include "Poco/WebWidgets/ListBoxCell.h"
#include "Poco/WebWidgets/ListBox.h"
#include "Poco/WebWidgets/RequestHandler.h"
#include "Poco/WebWidgets/Table.h"
#include "Poco/Net/HTTPServerResponse.h"
#include "Poco/Delegate.h"
#include "Poco/NumberFormatter.h"
#include <sstream>


namespace Poco {
namespace WebWidgets {
namespace ExtJS {


const std::string ListBoxCellRenderer::EV_SELECTIONCHANGED("selectionchange");


ListBoxCellRenderer::ListBoxCellRenderer()
{
}


ListBoxCellRenderer::~ListBoxCellRenderer()
{
}


void ListBoxCellRenderer::renderHead(const Renderable* pRenderable, const RenderContext& context, std::ostream& ostr)
{
	poco_assert_dbg (pRenderable != 0);
	poco_assert_dbg (pRenderable->type() == typeid(Poco::WebWidgets::ListBoxCell));
	const ListBoxCell* pListBoxCell = static_cast<const Poco::WebWidgets::ListBoxCell*>(pRenderable);

	ostr << "new Ext.ux.Multiselect({";

	ListBoxCellRenderer::renderProperties(pListBoxCell, ostr);

	ostr << "})";
}


void ListBoxCellRenderer::renderBody(const Renderable* pRenderable, const RenderContext& context, std::ostream& ostr)
{
}


void ListBoxCellRenderer::renderProperties(const ListBoxCell* pListBoxCell, std::ostream& ostr)
{
	Utility::writeCellProperties(pListBoxCell, ostr);

	const View* pOwner = pListBoxCell->getOwner();
	poco_check_ptr (pOwner);
	const ListBox* pList = dynamic_cast<const ListBox*>(pOwner);

	if (pOwner->hasPosition())
		ostr << ",x:" << pOwner->getPosition().posX << ",y:" << pOwner->getPosition().posY;
		
	if (!pListBoxCell->autoScroll())
		ostr << ",autoScroll:false";
	
	if (pList)
	{
		bool hasListeners = pList->selectionChanged.hasJavaScriptCode() || !pList->rowSelected.empty() || !pList->rowDeselected.empty();
		if (hasListeners)
		{
			ostr << ",listeners:{";
			Utility::writeJSEvent(ostr, EV_SELECTIONCHANGED, pList->selectionChanged, &ListBoxCellRenderer::createSelectionChangedServerCallback, pList);
			
			ostr << "}";
		}
	}

	// store: afterLoad, beforeLaod event
	ostr << ",store:new Ext.data.SimpleStore({autoLoad:true,fields:[{name:'i'},{name:'d'}]";
		ostr << ",proxy:new Ext.data.HttpProxy({url:";
		std::map<std::string, std::string> addParams;
		addParams.insert(std::make_pair(RequestHandler::KEY_EVID, ListBoxCell::EV_LOADDATA));
		std::string url(Utility::createURI(addParams, pList->id()));
		ostr << url << "})";
		ostr << ",reader:new Ext.data.ArrayReader()";
		if (pList->afterLoad.hasJavaScriptCode())
		{
			ostr << ",listeners:{";
				Utility::writeJSEvent(ostr, Table::EV_AFTERLOAD, pList->afterLoad, &ListBoxCellRenderer::createAfterLoadServerCallback, pList);
			ostr << "}";
		}
	
	ostr << "})";
	ostr << ",dataFields:['i','d'],initVal:[";

	//now serialize data, use cached content for that
	ListBoxCell::Data::const_iterator itV = pListBoxCell->begin();
	ListBoxCell::Data::const_iterator itVEnd = pListBoxCell->end();
	bool selected=false;
	int cnt(0);
	for (; itV != itVEnd; ++itV, ++cnt)
	{
		if (itV->second)
		{
			if (selected)
				ostr << ",";
			ostr << cnt;
			selected = true;
		}
	}
	ostr << "]";
	ostr << ",valueField:'i',displayField:'d'";

	ListBoxCell* pL = const_cast<ListBoxCell*>(pListBoxCell);
	pL->beforeLoad += Poco::delegate(&ListBoxCellRenderer::onBeforeLoad);
	WebApplication::instance().registerAjaxProcessor(Poco::NumberFormatter::format(pList->id()), pL);
	if (!pOwner->getName().empty())
	{
		WebApplication::instance().registerFormProcessor(pOwner->getName(), pL);
	}
}


Poco::WebWidgets::JSDelegate ListBoxCellRenderer::createSelectionChangedServerCallback(const ListBox* pList)
{
	// selectionchange : ( dataView, selArray )
	static const std::string signature("function(ms, v, s, idx)");
	std::map<std::string, std::string> addParams;
	addParams.insert(std::make_pair(ListBoxCell::ARG_ROW, "+idx"));
	addParams.insert(std::make_pair(RequestHandler::KEY_EVID, ListBoxCell::EV_SELECTIONCHANGED));
	return Utility::createServerCallback(signature, addParams, pList->id(), pList->selectionChanged.getOnSuccess(), pList->selectionChanged.getOnFailure());
}


Poco::WebWidgets::JSDelegate ListBoxCellRenderer::createAfterLoadServerCallback(const ListBox* pList)
{
	poco_check_ptr (pList);
	static const std::string signature("function(aStore, recs, op)");
	std::map<std::string, std::string> addParams;
	addParams.insert(std::make_pair(RequestHandler::KEY_EVID, ListBoxCell::EV_AFTERLOAD));
	return Utility::createServerCallback(signature, addParams, pList->id(), pList->afterLoad.getOnSuccess(), pList->afterLoad.getOnFailure());
}


void ListBoxCellRenderer::onBeforeLoad(void* pSender, std::pair<ListBoxCell*, Poco::Net::HTTPServerResponse*>& ld)
{
	ld.second->setChunkedTransferEncoding(true);
	ld.second->setContentType("text/javascript");
	std::ostream& ostr = ld.second->send();
	//[
    //    ['3m Co',71.72,0.02,0.03,'9/1 12:00am'],
    //    ['Alcoa Inc',29.01,0.42,1.47,'9/1 12:00am']
	//]
	ostr << "[";
	ListBoxCell::StringData::const_iterator it = ld.first->beginString();
	ListBoxCell::StringData::const_iterator itEnd = ld.first->endString();
	int cnt = 0;
	for (; it != itEnd; ++it, ++cnt)
	{
		if (it != ld.first->beginString())
			ostr << ",";

		ostr << "['" << cnt << "','" << *it << "']";
	}
	ostr << "]";
}


} } } // namespace Poco::WebWidgets::ExtJS
