//
// LayoutRenderer.cpp
//
// $Id: //poco/Main/WebWidgets/ExtJS/src/LayoutRenderer.cpp#5 $
//
// Library: ExtJS
// Package: Core
// Module:  LayoutRenderer
//
// Copyright (c) 2007, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#include "Poco/WebWidgets/ExtJS/LayoutRenderer.h"
#include "Poco/WebWidgets/ExtJS/FormRenderer.h"
#include "Poco/WebWidgets/ExtJS/Utility.h"
#include "Poco/WebWidgets/Layout.h"
#include "Poco/WebWidgets/VerticalLayout.h"
#include "Poco/WebWidgets/AbsoluteLayout.h"
#include "Poco/WebWidgets/Frame.h"
#include "Poco/WebWidgets/Panel.h"
#include <sstream>


namespace Poco {
namespace WebWidgets {
namespace ExtJS {


LayoutRenderer::LayoutRenderer()
{
}


LayoutRenderer::~LayoutRenderer()
{
}


void LayoutRenderer::renderBody(const Renderable* pRenderable, const RenderContext& context, std::ostream& ostr)
{
	const Layout* pLayout = static_cast<const Layout*>(pRenderable);
	ContainerView::ConstIterator it = pLayout->begin();
	int cnt(0);	
	for (; it != pLayout->end(); ++it)
	{
		(*it)->renderBody(context, ostr);
	}
}


void LayoutRenderer::renderLayout(const Layout* pLayout, const RenderContext& context, std::ostream& ostr, std::size_t cols, int padHorVal, int padVertVal)
{
	poco_assert_dbg (pLayout != 0);
	
	Renderable::ID id(0);
	View::Ptr ptrParent = pLayout->parent();
	bool parentIsNotPanel = !(ptrParent && (ptrParent.cast<Frame>() || ptrParent.cast<Panel>()));
	if (parentIsNotPanel)
	{
		// the parent is not a panel 
		// fake the the direct parent to be a panel
		ostr << "new Ext.Panel({border:false,bodyBorder:false,";
		ostr << "id:'" << pLayout->id() << "',";
		if (!pLayout->isVisible())
			ostr << "hidden:true,";
	}
	
	renderParameters(pLayout, context, ostr, cols, padHorVal, padVertVal);
	
	if (parentIsNotPanel)
		ostr << "})";
}


void LayoutRenderer::renderParameters(const Layout* pLayout, const RenderContext& context, std::ostream& ostr, std::size_t cols, int padHorVal, int padVertVal)
{
	poco_assert_dbg(pLayout != 0);
	if (padHorVal < 0)
		padHorVal = 0;
	if (padVertVal < 0)
		padVertVal = 0;
		
	if (pLayout->getWidth() > 0)
		ostr << "width:" << pLayout->getWidth() << ",";
	else
		ostr << "width:'auto',";
	if (pLayout->getHeight() > 0)
		ostr << "height:" << pLayout->getHeight() << ",";
	else
		ostr << "height:'auto',";
	
	ostr << "layout:'table'";
	ostr << ",layoutConfig:" << "{columns:" << cols << "}";
	if (pLayout->hasPosition())
		ostr << ",x:" << pLayout->getPosition().posX << ",y:" << pLayout->getPosition().posY;

	if (padHorVal > 0 || padVertVal > 0)
	{
		ostr << ",defaults:{";
		ostr <<		"bodyStyle:'";
		ostr <<			"padding:" << padVertVal << "px " << padHorVal << "px";
		ostr <<		"'";
		ostr <<	"}";
	}
	
	ostr << ",items:[";
		
	ContainerView::ConstIterator it = pLayout->begin();
	int cnt(0);	
	for (; it != pLayout->end(); ++it)
	{
		if (it != pLayout->begin())
			ostr << ",";
		if (*it)
		{
			//horizontallayout works only when children are panels
			bool writePanel = ((*it)->type() != typeid(AbsoluteLayout) && (*it)->type() != typeid(Panel) && (*it)->type() != typeid(Frame));
			if (writePanel)
				ostr << "new Ext.Panel({border:false,bodyBorder:false,items:[";
			(*it)->renderHead(context, ostr);
			if (writePanel)
				ostr << "]})";
		}
		else
			ostr << "{}";
	}
	ostr << "]";
}

} } } // namespace Poco::WebWidgets::ExtJS
