//
// FormRenderer.cpp
//
// $Id: //poco/Main/WebWidgets/ExtJS/src/FormRenderer.cpp#7 $
//
// Library: ExtJS
// Package: Core
// Module:  FormRenderer
//
// Copyright (c) 2007, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#include "Poco/WebWidgets/ExtJS/FormRenderer.h"
#include "Poco/WebWidgets/Form.h"
#include "Poco/WebWidgets/Button.h"
#include "Poco/WebWidgets/WebApplication.h"
#include "Poco/WebWidgets/RequestHandler.h"
#include "Poco/NumberFormatter.h"
#include <sstream>


namespace Poco {
namespace WebWidgets {
namespace ExtJS {


FormRenderer::FormRenderer()
{
}


FormRenderer::~FormRenderer()
{
}


void FormRenderer::renderHead(const Renderable* pRenderable, const RenderContext& context, std::ostream& ostr)
{
	poco_assert_dbg (pRenderable != 0);
	poco_assert_dbg (pRenderable->type() == typeid(Poco::WebWidgets::Form));
	const Form* pForm = static_cast<const Poco::WebWidgets::Form*>(pRenderable);
	WebApplication& theApp = WebApplication::instance();
	theApp.beginForm(*pForm);
	ostr << "new Ext.FormPanel({id:'" << pForm->id() << "',";

	//ostr << "onSubmit:Ext.emptyFn,submit:function(){this.getEl().dom.submit();},";
	if (pForm->getMethod() == Form::METHOD_POST)
		ostr << "method:'POST',";
	if (pForm->hasPosition())
		ostr << "x:" << pForm->getPosition().posX << ",y:" << pForm->getPosition().posY << ",";	
	ostr << "title:'" << pForm->getName() << "',autoHeight:true,autoWidth:true,autoScroll:true,url:'" << pForm->getURI().toString() << "',frame:true,items:[";
	//we need to add a hidden entry that contains the Form::FORM_ID plus its id
	ostr << "new Ext.form.Hidden({name:'" << Form::FORM_ID << "', value:" << pForm->id() << "})";
	
	ContainerView::ConstIterator it = pForm->begin();
	ContainerView::ConstIterator itEnd = pForm->end();
	for (; it != itEnd; ++it)
	{
		ostr << ",";
		// it points to a view pointer
		(*it)->renderHead(context, ostr);
		
	}
	ostr << "]})";
	theApp.endForm(*pForm);
	WebApplication::instance().registerAjaxProcessor(Poco::NumberFormatter::format(pForm->id()), const_cast<Form*>(pForm));
}


void FormRenderer::renderBody(const Renderable* pRenderable, const RenderContext& context, std::ostream& ostr)
{
}


std::string FormRenderer::formVariableName(const Form* pForm)
{
	static const std::string prefix("f");
	return prefix + Poco::NumberFormatter::format(pForm->id());
}


Poco::WebWidgets::JSDelegate FormRenderer::createReloadFunction(const std::string& fctName, const Form* pForm, const std::string& onSuccess, const std::string& onFailure)
{
	std::ostringstream out;
	out << "function ";
	out << fctName << "(){" << std::endl;
	out <<		"var theForm = Ext.getCmp('" << pForm->id() << "');" << std::endl;
	out <<		"var uri = '" << pForm->getURI().toString() << "/;" << RequestHandler::KEY_EVID << "=" << Form::EV_RELOAD << "&";
	out <<	RequestHandler::KEY_ID << "=" << pForm->id() << "';" << std::endl;
	out <<		"theForm.load({" << std::endl;
	out <<				"url:uri,method:'GET'" << std::endl;
	if (!onSuccess.empty())
	{
		out <<			",success: function(form, action){" << std::endl; 
		out <<				"form.addListener('actioncomplete', " << onSuccess << ");" << std::endl;
		out <<			"}" << std::endl;
	}	
	if (!onFailure.empty())
	{
		out <<			",failure: function(form, action){" << std::endl; 
		out <<				"form.addListener('actionfailed', " << onFailure << ");" << std::endl;
		out <<			"}" << std::endl;
	}	
	out <<		"});" << std::endl; // success, failure handlers
	out <<	"}" << std::endl;
	return jsDelegate(out.str());
}


} } } // namespace Poco::WebWidgets::ExtJS
