//
// DateFieldCellRenderer.cpp
//
// $Id: //poco/Main/WebWidgets/ExtJS/src/DateFieldCellRenderer.cpp#2 $
//
// Library: ExtJS
// Package: Core
// Module:  DateFieldCellRenderer
//
// Copyright (c) 2007, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#include "Poco/WebWidgets/ExtJS/DateFieldCellRenderer.h"
#include "Poco/WebWidgets/ExtJS/TextFieldCellRenderer.h"
#include "Poco/WebWidgets/ExtJS/FormRenderer.h"
#include "Poco/WebWidgets/ExtJS/Utility.h"
#include "Poco/WebWidgets/DateFieldCell.h"
#include "Poco/WebWidgets/WebApplication.h"


namespace Poco {
namespace WebWidgets {
namespace ExtJS {


DateFieldCellRenderer::DateFieldCellRenderer()
{
}


DateFieldCellRenderer::~DateFieldCellRenderer()
{
}


void DateFieldCellRenderer::renderHead(const Renderable* pRenderable, const RenderContext& context, std::ostream& ostr)
{
	poco_assert_dbg (pRenderable != 0);
	poco_assert_dbg (pRenderable->type() == typeid(Poco::WebWidgets::DateFieldCell));
	const DateFieldCell* pCell = static_cast<const Poco::WebWidgets::DateFieldCell*>(pRenderable);

	ostr << "new Ext.form.DateField({";

	DateFieldCellRenderer::writeCellProperties(pCell, ostr);

	ostr << "})";
	if (pCell->getOwner() && !pCell->getOwner()->getName().empty())
	{
		WebApplication::instance().registerFormProcessor(pCell->getOwner()->getName(), const_cast<DateFieldCell*>(pCell));
	}
}


void DateFieldCellRenderer::renderBody(const Renderable* pRenderable, const RenderContext& context, std::ostream& ostr)
{
}


void DateFieldCellRenderer::writeCellProperties(const DateFieldCell* pCell, std::ostream& ostr)
{
	TextFieldCellRenderer::writeCellProperties(pCell, ostr); 
	//a time value in UTC timezone will have a Z at the end of the time
	//unfortunately there is a bug in the iso8601 code of extjs 2.0.2
	//it fails to parse the Z
	// we avoid that bug in the WebWidgets DateFormatter where values are never written with UTC but with 0 offset if required
	const std::string& fmt = pCell->getFormat();
	ostr << ",format:'" << Utility::convertPocoDateToPHPDate(fmt) << "'";
}


} } } // namespace Poco::WebWidgets::ExtJS
