//
// CellInitializer.cpp
//
// $Id: //poco/Main/WebWidgets/ExtJS/src/CellInitializer.cpp#3 $
//
// Library: ExtJS
// Package: Core
// Module:  CellInitializer
//
// Copyright (c) 2007, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#include "Poco/WebWidgets/ExtJS/CellInitializer.h"
#include "Poco/WebWidgets/ExtJS/AbstractTableCellHandler.h"
#include "Poco/WebWidgets/ExtJS/Utility.h"
#include "Poco/WebWidgets/ToggleButtonCell.h"
#include "Poco/WebWidgets/CheckButtonCell.h"
#include "Poco/WebWidgets/TextEditCell.h"
#include "Poco/WebWidgets/TextFieldCell.h"
#include "Poco/WebWidgets/ComboBoxCell.h"
#include "Poco/WebWidgets/ButtonCell.h"
#include "Poco/WebWidgets/DateFieldCell.h"
#include "Poco/NumberFormatter.h"


namespace Poco {
namespace WebWidgets {
namespace ExtJS {


void cellInitializer(const Cell* pCell, AbstractTableCellHandler* pHandler)
{
	//don't support label for cell, keep this separate
	pHandler->addFixed("hideLabel", "true");
	if (!pCell->isEnabled())
		pHandler->addFixed("disabled", "true");
	View* pOwner = pCell->getOwner();
	if (pOwner)
	{
		if (pOwner->getWidth() > 0)
			pHandler->addFixed("width", Poco::NumberFormatter::format(pOwner->getWidth()));
		if (pOwner->getHeight() > 0)
			pHandler->addFixed("height", Poco::NumberFormatter::format(pOwner->getHeight()));
/*		if (!pOwner->getName().empty())
			pHandler->addFixed("name", "'"+pOwner->getName()+"'"); */
	}
}


void cellInitializer(const ToggleButtonCell* pToggleButtonCell, AbstractTableCellHandler* pHandler)
{
	if (!pToggleButtonCell->getLabel().empty())
		pHandler->addFixed("boxLabel", "'" + Utility::safe(pToggleButtonCell->getLabel()) + "'");
	// renderer is always readonly
	pHandler->addFixed("disabled", "true");
	//tooltip is not supported by togglebutton
	std::string tooltip (pToggleButtonCell->getToolTip());
	if (!tooltip.empty())
	{
		std::string fct("{render:function(c){c.getEl().dom.qtip='");
		fct.append(Utility::safe(tooltip));
		fct.append("'; c.getEl().dom.qclass = 'x-form-tip';}}");
		pHandler->addFixed("listeners", fct);
	}
	
	const Cell* pCell = pToggleButtonCell;
	cellInitializer(pCell, pHandler);
}


void cellInitializer(const CheckButtonCell* pCell, AbstractTableCellHandler* pHandler)
{
	const ToggleButtonCell* pToggleButtonCell = pCell;
	cellInitializer(pToggleButtonCell, pHandler);
}


void cellInitializer(const TextEditCell* pCell, AbstractTableCellHandler* pHandler)
{
	cellInitializer(static_cast<const Cell*>(pCell), pHandler);
	
	if (!pCell->isEditable())
		pHandler->addFixed("readOnly", "true");
	if (pCell->getHeightInPixel() > 0)
		pHandler->addFixed("height", Poco::NumberFormatter::format(pCell->getHeightInPixel()));
	if (pCell->getGrow())
		pHandler->addFixed("grow","true");

	if (!pCell->getPlaceHolder().empty())
		pHandler->addFixed("emptyText", "'" + Utility::safe(pCell->getPlaceHolder())  + "'");

	//tooltip is not supported by textEdit, add listeners
	std::string tooltip (pCell->getToolTip());
	if (!tooltip.empty())
	{
		std::string fct("{render: function(c) {Ext.QuickTips.register({target: c.getEl(),text: '");
		fct.append(Utility::safe(tooltip));
		fct.append("'});}}");
		pHandler->addFixed("listeners", fct);
	}
}


void cellInitializer(const TextFieldCell* pCell, AbstractTableCellHandler* pHandler)
{
	cellInitializer(static_cast<const Cell*>(pCell), pHandler);
	
	if (!pCell->isEditable())
		pHandler->addFixed("readOnly", "true");

	if (pCell->getMaxLength() > 0)
		pHandler->addFixed("maxLength", Poco::NumberFormatter::format(pCell->getMaxLength()));

	if (!pCell->getPlaceHolder().empty())
		pHandler->addFixed("emptyText", "'" + Utility::safe(pCell->getPlaceHolder())  + "'");

	//tooltip is not supported by textEdit, add listeners
	std::string tooltip (pCell->getToolTip());
	if (!tooltip.empty())
	{
		std::string fct("{render: function(c) {Ext.QuickTips.register({target: c.getEl(),text: '");
		fct.append(Utility::safe(tooltip));
		fct.append("'});}}");
		pHandler->addFixed("listeners", fct);
	}
}


void cellInitializer(const ComboBoxCell* pCell, AbstractTableCellHandler* pHandler)
{
	cellInitializer(static_cast<const TextFieldCell*>(pCell), pHandler);
	std::string store("new Ext.data.SimpleStore({fields:['d'], data:[");

	//now serialize data
	std::vector<Any>::const_iterator it = pCell->begin();
	std::vector<Any>::const_iterator itEnd = pCell->end();
	Formatter::Ptr ptrFormatter = pCell->getFormatter();
	for (; it != itEnd; ++it)
	{
		if (it != pCell->begin())
			store.append(",");
		store.append("['");
		if (ptrFormatter)
			store.append(ptrFormatter->format(*it));
		else
			store.append(RefAnyCast<std::string>(*it));
		store.append("']");
	}
	store.append("]})");
	pHandler->addFixed("store", store);
	pHandler->addFixed("displayField", "'d'");
	pHandler->addFixed("typeAhead","true");
	pHandler->addFixed("mode", "'local'");
	pHandler->addFixed("triggerAction","'all'");
}


void cellInitializer(const ButtonCell* pCell, AbstractTableCellHandler* pHandler)
{
	cellInitializer(static_cast<const Cell*>(pCell), pHandler);
	
	std::string toolTip(pCell->getToolTip());
	if (!toolTip.empty())
		pHandler->addFixed("tooltip:", "'" + Utility::safe(toolTip) + "'");
}


} } } // namespace Poco::WebWidgets::ExtJS
