//
// AbsoluteLayoutRenderer.cpp
//
// $Id: //poco/Main/WebWidgets/ExtJS/src/AbsoluteLayoutRenderer.cpp#1 $
//
// Library: ExtJS
// Package: Core
// Module:  AbsoluteLayoutRenderer
//
// Copyright (c) 2007, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#include "Poco/WebWidgets/ExtJS/AbsoluteLayoutRenderer.h"
#include "Poco/WebWidgets/ExtJS/Utility.h"
#include "Poco/WebWidgets/AbsoluteLayout.h"
#include "Poco/WebWidgets/Frame.h"
#include "Poco/WebWidgets/Panel.h"
#include <sstream>


namespace Poco {
namespace WebWidgets {
namespace ExtJS {


AbsoluteLayoutRenderer::AbsoluteLayoutRenderer()
{
}


AbsoluteLayoutRenderer::~AbsoluteLayoutRenderer()
{
}


void AbsoluteLayoutRenderer::renderHead(const Renderable* pRenderable, const RenderContext& context, std::ostream& ostr)
{
	poco_assert_dbg (pRenderable != 0);
	poco_assert_dbg (pRenderable->type() == typeid(Poco::WebWidgets::AbsoluteLayout));
	const AbsoluteLayout* pLayout = static_cast<const Poco::WebWidgets::AbsoluteLayout*>(pRenderable);
	
	Renderable::ID id(0);
	View::Ptr ptrParent = pLayout->parent();
	bool parentIsFrame = (ptrParent && ptrParent->type() == typeid(Frame));
	bool parentIsPanel = (ptrParent && ptrParent->type() == typeid(Panel));
	bool parentIsNotPanel = !(parentIsFrame || parentIsPanel);
	Poco::UInt32 width = pLayout->getWidth();
	Poco::UInt32 height = pLayout->getHeight();
	if (parentIsNotPanel)
	{
		// the parent is not a panel 
		// fake the the direct parent to be a panel
		ostr << "new Ext.Panel({border:false,bodyBorder:false,";
		ostr << "id:'" << pLayout->id() << "',";
		if (!pLayout->isVisible())
			ostr << "hidden:true,";
		
		if (width == 0)
			width = ptrParent->getWidth();
		if (height == 0)
			height = ptrParent->getHeight();
	}
	
	if (width == 0)
		width = 100;
	if (height == 0)
		height = 100;
	ostr << "width:" << width;	
	ostr << ",height:" << height;
	
	
	ostr << ",layout:'absolute'";
	if (pLayout->hasPosition())
		ostr << ",x:" << pLayout->getPosition().posX << ",y:" << pLayout->getPosition().posY;
	ostr << ",items:[";
		
	ContainerView::ConstIterator it = pLayout->begin();
	int cnt(0);	
	for (; it != pLayout->end(); ++it)
	{
		if (it != pLayout->begin())
			ostr << ",";
		if (*it)
		{
			(*it)->renderHead(context, ostr);
		}
		else
			ostr << "{}";
	}
	ostr << "]";
	
	if (parentIsNotPanel)
		ostr << "})";
}


} } } // namespace Poco::WebWidgets::ExtJS
