//
// ToggleButtonCellRenderer.h
//
// $Id: //poco/Main/WebWidgets/ExtJS/include/Poco/WebWidgets/ExtJS/ToggleButtonCellRenderer.h#4 $
//
// Library: ExtJS
// Package: Core
// Module:  ToggleButtonCellRenderer
//
// Definition of the ToggleButtonCellRenderer class.
//
// Copyright (c) 2007, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#ifndef ExtJS_ToggleButtonCellRenderer_INCLUDED
#define ExtJS_ToggleButtonCellRenderer_INCLUDED


#include "Poco/WebWidgets/ExtJS/CellRenderer.h"
#include "Poco/WebWidgets/JSDelegate.h"


namespace Poco {
namespace WebWidgets {

	class ToggleButtonCell;
	class ToggleButton;

namespace ExtJS {


class ExtJS_API ToggleButtonCellRenderer: public Poco::WebWidgets::Renderer
	/// Abstract ToggleButtonCellRenderer renders a ToggleButton
{
public:
	static const std::string EV_CHECKED;
	
	void writeConfigData(const Cell* pCell, const RenderContext& context, std::ostream& ostr);
		/// writes ConfigData, is a simple boolean containing isChecked

	static void renderProperties(const ToggleButtonCell* pCell, std::ostream& ostr);
		/// Renders button properties

	void renderBody(const Renderable* pRenderable, const RenderContext& context, std::ostream& ostr);
	
	static Poco::WebWidgets::JSDelegate createCheckedServerCallback(const ToggleButton* pButton);
		/// Adds a server callback for the change event. The method signature is
		/// check : ( Ext.form.Checkbox this, Boolean checked ) 

protected:
	ToggleButtonCellRenderer();
		/// Creates the ToggleButtonCellRenderer.

	virtual ~ToggleButtonCellRenderer();
		/// Destroys the ToggleButtonCellRenderer.
};


} } } // namespace Poco::WebWidgets::ExtJS


#endif // ExtJS_ToggleButtonCellRenderer_INCLUDED
