//
// FormRenderer.h
//
// $Id: //poco/Main/WebWidgets/ExtJS/include/Poco/WebWidgets/ExtJS/FormRenderer.h#2 $
//
// Library: ExtJS
// Package: Core
// Module:  FormRenderer
//
// Definition of the FormRenderer class.
//
// Copyright (c) 2007, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#ifndef ExtJS_FormRenderer_INCLUDED
#define ExtJS_FormRenderer_INCLUDED


#include "Poco/WebWidgets/ExtJS/ExtJS.h"
#include "Poco/WebWidgets/Renderer.h"
#include "Poco/WebWidgets/Form.h"
#include "Poco/WebWidgets/JSDelegate.h"

namespace Poco {
namespace WebWidgets {
	class Form;
namespace ExtJS {


class ExtJS_API FormRenderer: public Poco::WebWidgets::Renderer
	/// FormRenderer renders Form
{
public:
	FormRenderer();
		/// Creates the FormRenderer.

	virtual ~FormRenderer();
		/// Destroys the FormRenderer.

	void renderHead(const Renderable* pRenderable, const RenderContext& context, std::ostream& ostr);
		/// Emits code for the page header to the given output stream.

	void renderBody(const Renderable* pRenderable, const RenderContext& context, std::ostream& ostr);
		/// Emits code for the page body to the given output stream.

	static std::string formVariableName(const Form* pForm);
		/// Creates the variable name for the form
		
	static Poco::WebWidgets::JSDelegate createReloadFunction(const std::string& fctName, const Form* pForm, const std::string& onSuccess="", const std::string& failure="");
		/// Creates a function with the given fctName (can be empty) that reloads the form
		/// E.g.: add the returned JSDelegate to pReload->buttonClicked
};


} } } // namespace Poco::WebWidgets::ExtJS


#endif // ExtJS_FormRenderer_INCLUDED
