//
// DynamicCodeLoaderRenderer.h
//
// $Id: //poco/Main/WebWidgets/ExtJS/include/Poco/WebWidgets/ExtJS/DynamicCodeLoaderRenderer.h#2 $
//
// Library: ExtJS
// Package: Core
// Module:  DynamicCodeLoaderRenderer
//
// Definition of the DynamicCodeLoaderRenderer class.
//
// Copyright (c) 2007, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#ifndef ExtJS_DynamicCodeLoaderRenderer_INCLUDED
#define ExtJS_DynamicCodeLoaderRenderer_INCLUDED


#include "Poco/WebWidgets/ExtJS/ExtJS.h"
#include "Poco/WebWidgets/Renderer.h"


namespace Poco {
namespace WebWidgets {
	class DynamicCodeLoader;
namespace ExtJS {


class ExtJS_API DynamicCodeLoaderRenderer: public Poco::WebWidgets::Renderer
	/// DynamicCodeLoaderRenderer renders a vertical Layout
{
public:
	DynamicCodeLoaderRenderer();
		/// Creates the DynamicCodeLoaderRenderer.

	virtual ~DynamicCodeLoaderRenderer();
		/// Destroys the DynamicCodeLoaderRenderer.

	void renderHead(const Renderable* pRenderable, const RenderContext& context, std::ostream& ostr);
		/// Emits code for the page header to the given output stream.
		
	void renderBody(const Renderable* pRenderable, const RenderContext& context, std::ostream& ostr);
		/// Emits code for the page body to the given output stream.	

	static void renderVariables(const DynamicCodeLoader* pLoader, const RenderContext& context, std::ostream& ostr);
		// You must first call renderVariables then renderHead
		
private:
	static void onCodeGen(DynamicCodeLoader* &pLoader);
};


} } } // namespace Poco::WebWidgets::ExtJS


#endif // ExtJS_DynamicCodeLoaderRenderer_INCLUDED
