//
// CellInitializer.h
//
// $Id: //poco/Main/WebWidgets/ExtJS/include/Poco/WebWidgets/ExtJS/CellInitializer.h#1 $
//
// Library: ExtJS
// Package: Core
// Module:  CellInitializer
//
// Definition of the CellInitializer class.
//
// Copyright (c) 2007, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#ifndef ExtJS_CellInitializer_INCLUDED
#define ExtJS_CellInitializer_INCLUDED


#include "Poco/WebWidgets/ExtJS/ExtJS.h"


namespace Poco {
namespace WebWidgets {

	class Cell;
	class ToggleButtonCell;
	class CheckButtonCell;
	class TextEditCell;
	class TextFieldCell;
	class ComboBoxCell;
	class ButtonCell;

namespace ExtJS {

	class AbstractTableCellHandler;


void ExtJS_API cellInitializer(const Cell* pCell, AbstractTableCellHandler* pHandler);
	/// Generic Initializer for Cells

void ExtJS_API cellInitializer(const ToggleButtonCell* pCell, AbstractTableCellHandler* pHandler);
	/// Inits the handler according to the ToggleButtonCell

void ExtJS_API cellInitializer(const CheckButtonCell* pCell, AbstractTableCellHandler* pHandler);
	/// Inits the handler according to the CheckButtonCell

void ExtJS_API cellInitializer(const TextEditCell* pCell, AbstractTableCellHandler* pHandler);
	/// Inits the handler according to the TextEditCell

void ExtJS_API cellInitializer(const TextFieldCell* pCell, AbstractTableCellHandler* pHandler);
	/// Inits the handler according to the TextFieldCell

void ExtJS_API cellInitializer(const ButtonCell* pCell, AbstractTableCellHandler* pHandler);
	/// Inits the handler according to the ComboBoxCell

void ExtJS_API cellInitializer(const ComboBoxCell* pCell, AbstractTableCellHandler* pHandler);
	/// Inits the handler according to the ComboBoxCell

} } } // namespace Poco::WebWidgets::ExtJS


#endif // ExtJS_CellInitializer_INCLUDED
