//
// AbstractTableCellHandler.h
//
// $Id: //poco/Main/WebWidgets/ExtJS/include/Poco/WebWidgets/ExtJS/AbstractTableCellHandler.h#1 $
//
// Library: ExtJS
// Package: Core
// Module:  AbstractTableCellHandler
//
// Definition of the AbstractTableCellHandler class.
//
// Copyright (c) 2007, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#ifndef ExtJS_AbstractTableCellHandler_INCLUDED
#define ExtJS_AbstractTableCellHandler_INCLUDED


#include "Poco/WebWidgets/ExtJS/ExtJS.h"
#include "Poco/RefCountedObject.h"
#include "Poco/AutoPtr.h"
#include <ostream>


namespace Poco {
namespace WebWidgets {

	class Cell;

namespace ExtJS {


class ExtJS_API AbstractTableCellHandler: public RefCountedObject
	/// AbstractTableCellHandler
{
public:
	typedef AutoPtr<AbstractTableCellHandler> Ptr;

	AbstractTableCellHandler(bool editor, bool renderer);
		/// Creates an AbstractTableCellHandler

	virtual ~AbstractTableCellHandler();
		/// Destroys an AbstractTableCellHandler

	virtual void addFixed(const std::string& name, const std::string& fixedContent) = 0;
		/// Adds a variable with a given fixed string content. The content will not be wrapped
		/// with ' ' but will be written as is

	virtual void writeData(const void* pObj, std::ostream& out) = 0;
		/// Writes the content of the table used to dynamically
		/// initialize Table Columns

	virtual void writeDynamicData(std::ostream& out) = 0;
		/// Writes the Javascript callback function

	virtual AbstractTableCellHandler* clone() const = 0;
		/// Creates a deep-copy of the object

	virtual void init(const Cell* pCell) = 0;
		/// Initializes the TableCellHandler according to the cell

	bool useEditor() const;
		/// Returns true if we need to use the editor when the class is editable

	bool useRenderer() const;
		/// Returns true if we need to use a custom renderer to display the object

private:
	bool _editor;
	bool _renderer;
};


inline bool AbstractTableCellHandler::useEditor() const
{
	return _editor;
}


inline bool AbstractTableCellHandler::useRenderer() const
{
	return _renderer;
}

} } } // namespace Poco::WebWidgets::ExtJS


#endif // ExtJS_AbstractTableCellHandler_INCLUDED
