//
// SecureStreamSocket.cpp
//
// $Id: //poco/Main/NetSSL_OpenSSL/src/SecureStreamSocket.cpp#11 $
//
// Library: NetSSL_OpenSSL
// Package: SSLSockets
// Module:  SecureStreamSocket
//
// Copyright (c) 2006-2009, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#include "Poco/Net/SecureStreamSocket.h"
#include "Poco/Net/SecureStreamSocketImpl.h"
#include "Poco/Net/SocketImpl.h"
#include "Poco/Net/SSLManager.h"
#include "Poco/Exception.h"


using Poco::InvalidArgumentException;


namespace Poco {
namespace Net {


SecureStreamSocket::SecureStreamSocket(): 
	StreamSocket(new SecureStreamSocketImpl(SSLManager::instance().defaultClientContext()))
{
}


SecureStreamSocket::SecureStreamSocket(Context::Ptr pContext): 
	StreamSocket(new SecureStreamSocketImpl(pContext))
{
}


SecureStreamSocket::SecureStreamSocket(const SocketAddress& address): 
	StreamSocket(new SecureStreamSocketImpl(SSLManager::instance().defaultClientContext()))
{
	connect(address);
}


SecureStreamSocket::SecureStreamSocket(const SocketAddress& address, const std::string& hostName): 
	StreamSocket(new SecureStreamSocketImpl(SSLManager::instance().defaultClientContext()))
{
	static_cast<SecureStreamSocketImpl*>(impl())->setPeerHostName(hostName);
	connect(address);
}


SecureStreamSocket::SecureStreamSocket(const SocketAddress& address, Context::Ptr pContext): 
	StreamSocket(new SecureStreamSocketImpl(pContext))
{
	connect(address);
}


SecureStreamSocket::SecureStreamSocket(const SocketAddress& address, const std::string& hostName, Context::Ptr pContext): 
	StreamSocket(new SecureStreamSocketImpl(pContext))
{
	static_cast<SecureStreamSocketImpl*>(impl())->setPeerHostName(hostName);
	connect(address);
}


SecureStreamSocket::SecureStreamSocket(const Socket& socket): 
	StreamSocket(socket)
{
	if (!dynamic_cast<SecureStreamSocketImpl*>(impl()))
		throw InvalidArgumentException("Cannot assign incompatible socket");
}


SecureStreamSocket::SecureStreamSocket(SocketImpl* pImpl): 
	StreamSocket(pImpl)
{
	if (!dynamic_cast<SecureStreamSocketImpl*>(impl()))
		throw InvalidArgumentException("Cannot assign incompatible socket");
}


SecureStreamSocket::~SecureStreamSocket()
{
}


SecureStreamSocket& SecureStreamSocket::operator = (const Socket& socket)
{
	if (dynamic_cast<SecureStreamSocketImpl*>(socket.impl()))
		StreamSocket::operator = (socket);
	else
		throw InvalidArgumentException("Cannot assign incompatible socket");
	return *this;
}


X509Certificate SecureStreamSocket::peerCertificate() const
{
	return static_cast<SecureStreamSocketImpl*>(impl())->peerCertificate();
}


void SecureStreamSocket::setPeerHostName(const std::string& hostName)
{
	static_cast<SecureStreamSocketImpl*>(impl())->setPeerHostName(hostName);
}

	
const std::string& SecureStreamSocket::getPeerHostName() const
{
	return static_cast<SecureStreamSocketImpl*>(impl())->getPeerHostName();
}


SecureStreamSocket SecureStreamSocket::attach(const StreamSocket& streamSocket)
{
	SecureStreamSocketImpl* pImpl = new SecureStreamSocketImpl(static_cast<StreamSocketImpl*>(streamSocket.impl()), SSLManager::instance().defaultClientContext());
	SecureStreamSocket result(pImpl);
	pImpl->connectSSL();
	return result;
}


SecureStreamSocket SecureStreamSocket::attach(const StreamSocket& streamSocket, Context::Ptr pContext)
{
	SecureStreamSocketImpl* pImpl = new SecureStreamSocketImpl(static_cast<StreamSocketImpl*>(streamSocket.impl()), pContext);
	SecureStreamSocket result(pImpl);
	pImpl->connectSSL();
	return result;
}


SecureStreamSocket SecureStreamSocket::attach(const StreamSocket& streamSocket, const std::string& peerHostName)
{
	SecureStreamSocketImpl* pImpl = new SecureStreamSocketImpl(static_cast<StreamSocketImpl*>(streamSocket.impl()), SSLManager::instance().defaultClientContext());
	SecureStreamSocket result(pImpl);
	result.setPeerHostName(peerHostName);
	pImpl->connectSSL();
	return result;
}


SecureStreamSocket SecureStreamSocket::attach(const StreamSocket& streamSocket, const std::string& peerHostName, Context::Ptr pContext)
{
	SecureStreamSocketImpl* pImpl = new SecureStreamSocketImpl(static_cast<StreamSocketImpl*>(streamSocket.impl()), pContext);
	SecureStreamSocket result(pImpl);
	result.setPeerHostName(peerHostName);
	pImpl->connectSSL();
	return result;
}


Context::Ptr SecureStreamSocket::context() const
{
	return static_cast<SecureStreamSocketImpl*>(impl())->context();
}


} } // namespace Poco::Net
