//
// DirectoryIterator_VMS.cpp
//
// $Id: //poco/svn/Foundation/src/DirectoryIterator_VMS.cpp#2 $
//
// Library: Foundation
// Package: Filesystem
// Module:  DirectoryIterator
//
// Copyright (c) 2004-2006, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#include "Poco/DirectoryIterator_VMS.h"
#include "Poco/Path.h"
#include "Poco/Exception.h"
#include <iodef.h>
#include <atrdef.h>
#include <fibdef.h>
#include <starlet.h>


namespace Poco {


DirectoryIteratorImpl::DirectoryIteratorImpl(const std::string& path): _rc(1)
{
	Path p(path);
	p.makeDirectory();
	_search = p.toString();
	_search.append("*.*;*");

	_fab = cc$rms_fab;
	_fab.fab$l_fna = (char*) _search.c_str();
	_fab.fab$b_fns = _search.size();
	_fab.fab$l_nam = &_nam;

	_nam = cc$rms_nam;
	_nam.nam$l_esa = _spec;
	_nam.nam$b_ess = sizeof(_spec);

	if (sys$parse(&_fab) & 1)
		throw OpenFileException(path);

	next();
}


DirectoryIteratorImpl::~DirectoryIteratorImpl()
{
}


const std::string& DirectoryIteratorImpl::next()
{
	if (sys$search(&_fab) & 1)
		_current.clear();
	else
		_current.assign(_fab.fab$l_nam->nam$l_name, _fab.fab$l_nam->nam$b_name + _fab.fab$l_nam->nam$b_type);
	return _current;
}


} // namespace Poco
