//
// DateTimeFormat.cpp
//
// $Id: //poco/svn/Foundation/src/DateTimeFormat.cpp#2 $
//
// Library: Foundation
// Package: DateTime
// Module:  DateTimeFormat
//
// Copyright (c) 2004-2006, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#include "Poco/DateTimeFormat.h"


namespace Poco {


const std::string DateTimeFormat::ISO8601_FORMAT  = "%Y-%m-%dT%H:%M:%S%z";
const std::string DateTimeFormat::RFC822_FORMAT   = "%w, %e %b %y %H:%M:%S %Z";
const std::string DateTimeFormat::RFC1123_FORMAT  = "%w, %e %b %Y %H:%M:%S %Z";
const std::string DateTimeFormat::HTTP_FORMAT     = "%w, %d %b %Y %H:%M:%S %Z";
const std::string DateTimeFormat::RFC850_FORMAT   = "%W, %e-%b-%y %H:%M:%S %Z";
const std::string DateTimeFormat::RFC1036_FORMAT  = "%W, %e %b %y %H:%M:%S %Z";
const std::string DateTimeFormat::ASCTIME_FORMAT  = "%w %b %f %H:%M:%S %Y";
const std::string DateTimeFormat::SORTABLE_FORMAT = "%Y-%m-%d %H:%M:%S";


const std::string DateTimeFormat::WEEKDAY_NAMES[] =
{
	"Sunday",
	"Monday",
	"Tuesday",
	"Wednesday",
	"Thursday",
	"Friday",
	"Saturday"
};


const std::string DateTimeFormat::MONTH_NAMES[] =
{
	"January",
	"February",
	"March",
	"April",
	"May",
	"June",
	"July",
	"August",
	"September",
	"October",
	"November",
	"December"
};


} // namespace Poco
