//
// StatementImpl.h
//
// $Id: //poco/Main/Data/testsuite/src/StatementImpl.h#2 $
//
// Definition of the StatementImpl class.
//
// Copyright (c) 2006, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#ifndef Data_Test_StatementImpl_INCLUDED
#define Data_Test_StatementImpl_INCLUDED


#include "Poco/Data/StatementImpl.h"
#include "Poco/SharedPtr.h"
#include "Binder.h"
#include "Extractor.h"
#include "Preparator.h"


struct sqlite3;
struct sqlite3_stmt;


namespace Poco {
namespace Data {
namespace Test {


class StatementImpl: public Poco::Data::StatementImpl
	/// A no-op implementation of StatementImpl for testing.
{
public:
	StatementImpl();
		/// Creates the StatementImpl.

	~StatementImpl();
		/// Destroys the StatementImpl.

protected:
	bool hasNext();
		/// Returns true if a call to next() will return data.

	void next();
		/// Retrieves the next row from the resultset.
		/// Will throw, if the resultset is empty.

	bool canBind() const;
		/// Returns true if a valid statement is set and we can bind.

	void compileImpl();
		/// Compiles the statement, doesn't bind yet

	void bindImpl();
		/// Binds parameters

	AbstractExtractor& extractor();
		/// Returns the concrete extractor used by the statement.

	AbstractBinder& binder();
		/// Returns the concrete binder used by the statement.

private:
	Poco::SharedPtr<Binder>    _ptrBinder;
	Poco::SharedPtr<Extractor> _ptrExtractor;
	Poco::SharedPtr<Preparation> _ptrPrepare;
};


//
// inlines
//
inline AbstractExtractor& StatementImpl::extractor()
{
	return *_ptrExtractor;
}


inline AbstractBinder& StatementImpl::binder()
{
	return *_ptrBinder;
}


} } } // namespace Poco::Data::Test


#endif // Data_Test_StatementImpl_INCLUDED
