//
// Time.cpp
//
// $Id: //poco/Main/Data/src/Time.cpp#5 $
//
// Library: Data
// Package: DataCore
// Module:  Time
//
// Copyright (c) 2006, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#include "Poco/Data/Time.h"
#include "Poco/DateTime.h"


using Poco::DateTime;


namespace Poco {
namespace Data {


Time::Time()
{
	DateTime dt;
	assign(dt.hour(), dt.minute(), dt.second());
}


Time::Time(int hour, int minute, int second)
{
	assign(hour, minute, second);
}


Time::Time(const DateTime& dt)
{
	assign(dt.hour(), dt.minute(), dt.second());
}


Time::~Time()
{
}


void Time::assign(int hour, int minute, int second)
{
	if (hour < 0 || hour > 23) 
		throw InvalidArgumentException("Hour must be between 0 and 23.");

	if (minute < 0 || minute > 59) 
		throw InvalidArgumentException("Minute must be between 0 and 59.");

	if (second < 0 || second > 59) 
		throw InvalidArgumentException("Second must be between 0 and 59.");

	_hour = hour;
	_minute = minute;
	_second = second;
}


bool Time::operator < (const Time& time)
{
	int hour = time.hour();

	if (_hour < hour) return true;
	else if (_hour > hour) return false;
	else // hours equal
	{
		int minute = time.minute();
		if (_minute < minute) return true;
		else 
		if (_minute > minute) return false;
		else // minutes equal
		if (_second < time.second()) return true;
	}

	return false;
}


} } // namespace Poco::Data
