//
// Date.cpp
//
// $Id: //poco/Main/Data/src/Date.cpp#5 $
//
// Library: Data
// Package: DataCore
// Module:  Date
//
// Copyright (c) 2006, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#include "Poco/Data/Date.h"
#include "Poco/DateTime.h"
#include "Poco/NumberFormatter.h"


using Poco::DateTime;
using Poco::NumberFormatter;


namespace Poco {
namespace Data {


Date::Date()
{
	DateTime dt;
	assign(dt.year(), dt.month(), dt.day());
}


Date::Date(int year, int month, int day)
{
	assign(year, month, day);
}


Date::Date(const DateTime& dt)
{
	assign(dt.year(), dt.month(), dt.day());
}


Date::~Date()
{
}


void Date::assign(int year, int month, int day)
{
	if (year < 0 || year > 9999)
		throw InvalidArgumentException("Year must be between 0 and 9999");

	if (month < 1 || month > 12)
		throw InvalidArgumentException("Month must be between 1 and 12");

	if (day < 1 || day > DateTime::daysOfMonth(year, month))
		throw InvalidArgumentException("Month must be between 1 and " + 
			NumberFormatter::format(DateTime::daysOfMonth(year, month)));

	_year = year;
	_month = month;
	_day = day;
}


bool Date::operator < (const Date& date)
{
	int year = date.year();

	if (_year < year) return true;
	else if (_year > year) return false;
	else // years equal
	{
		int month = date.month();
		if (_month < month) return true;
		else 
		if (_month > month) return false;
		else // months equal
		if (_day < date.day()) return true;
	}

	return false;
}


} } // namespace Poco::Data
