//------------------------------------------------------------------------------
//	Copyright (C) 2009 Humboldt-Universitaet zu Berlin
//
//	This library is free software; you can redistribute it and/or
//	modify it under the terms of the GNU Lesser General Public
//	License as published by the Free Software Foundation; either
//	version 2.1 of the License, or (at your option) any later version.
//
//	This library is distributed in the hope that it will be useful,
//	but WITHOUT ANY WARRANTY; without even the implied warranty of
//	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//	Lesser General Public License for more details.
//
//	You should have received a copy of the GNU Lesser General Public
//	License along with this library; if not, write to the Free Software
//	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/**
 * @file Example_DatabaseWriter.cpp
 * @author Ronald Kluth
 * @date created at 2010/04/24
 * @brief Example demonstrating how to use a DatabaseWriter
 * @since 3.0
 */

/**
 * @example Example_DatabaseWriter.cpp
 * The usage of the ODEMx database writer is demonstrated.
 *
 * Depending on the compile setup of ODEMx, the class DatabaseWriter
 * can either be used to connect to SQLite or to an external database system
 * via ODBC. The example shows how a connection string for a PostgreSQL
 * connection would look. In the current configuration, however, an SQLite
 * database file named "example_databasewriter.db" will be created.
 *
 * Then, a time formatter is set, and the writer is registered as log consumer.
 * The following use of the producer class StopWatch can then be observed
 * as record written to the database. The call to @c flush writes buffered
 * data to the database for permanent storage.
 */

#include "Example_Producer_StopWatch.h"

int main() {
	using namespace odemx;
	using namespace odemx::data::output;

	typedef std::tr1::shared_ptr< DatabaseWriter > DatabaseWriterPtr;
	/*	DatabaseWriterPtr dbWriter = DatabaseWriter::create(
				"Driver=PostgreSQL_Driver;"
				"UID=username;"
				"PWD=password;"
				"Database=odemx_example_database;"
				"Server=localhost;"
				"Port=5433;", 10000 );
	*/
	DatabaseWriterPtr dbWriter = DatabaseWriter::create(
			"example_databasewriter.db", 10000 );

	dbWriter->setTimeFormat( new GermanTime(
			TimeBase( 2009, 4, 4, 16*60*60, TimeUnit::seconds ) ) );

	base::Simulation& sim = getDefaultSimulation();
	sim.addConsumer( dbWriter );

	StopWatch watch( sim, "Stop Watch" );
	watch.start();
	sim.setCurrentTime( 10 );
	watch.stop();

	try { dbWriter->flush(); }
	catch( Poco::Exception& ex ) { std::cout << ex.displayText(); }
}
