[TOC]

Building ODEMx
==============

Requirements
------------

### All Platforms

- [CMake][] (version >= 2.8)
- POCO (revision 1094)
    - NOTE: The latest POCO release (currently 1.4.x) cannot be used because CppLog uses unreleased POCO classes. Thats why revision 1094 (which already includes these classes) from the POCO SVN repository must be used.
- GSL
    - __TODO: Do we need to use version 1.13 or can we also use the latest one? if not why?__

[CMake]: http://www.cmake.org

### Linux, MacOS, Gygwin, MinGW

- make
- g++
    - tested with g++ 4.4 and 4.5.1
    - might also work with earlier versions if they support tr1 and RTTI
- subversion
    - needed when building poco with the external/contrib/install_contrib.sh script
    - NOTE: You need a svn client with a command line interface. On Windows, try SlikSVN
- wget or curl
    - to download gsl with external/contrib/install_contrib.sh script
- autotools
    - __TODO: still required?__

### Windows

- Visual Studio 2008 SP1 (Visual Studio 2010 not yet tested)
- GSL (...), see 2. Building Poco and GSL for further instructions
- POCO (...), see 2. Building Poco and GSL for further instructions

Active Developers by Build Environment
--------------------------------------

If you encounter problems when building ODEMx, contact a corresponding developer.

### Linux

- Magnus
- Toralf

### MacOS

- Andreas, <blunk@informatik.hu-berlin.de>
- Ingmar, <eveslage@informatik.hu-berlin.de>

### MinGW/MSYS

- Andreas, <blunk@informatik.hu-berlin.de>
- Ingmar, <eveslage@informatik.hu-berlin.de>

### Cygwin

- NONE

### Visual Studio

- NONE

Build Guide
-----------

*Preliminary Notes*

- in this guide `ODEMX_HOME` stands for the location of your ODEMx home directory (the absolute path)

*Additional Notes*

- If you develop with Eclipse, place your ODEMx build and install directories in the parent directory of `ODEMX_HOME` (e.g. `ODEMX_HOME/../build`).

### Building External Libraries

#### Linux, Unix, MinGW, Cygwin

##### Download (optional)

- __NOTE:__ you only need to download if the directory `ODEMX_HOME/external/contrib` does not already contain the following sub-directories:
    - `gsl-1.13`
    - `poco`
    - `UnitTest++`
- automatic downloading requires (wget or curl) and a SVN command line client
- cd to `ODEMX_HOME/external/contrib`
- run `download_contrib.sh`

##### Build

- create an install directory (location where all the binaries, libs, header files and docs will be placed) (e.g. `ODEMX_HOME/install`)
- cd to `external/contrib`
- run `install_contrib.sh` with the install directory (e.g. `./install_contrib.sh ../../install`)
(look into `install_contrib.sh` for details - e.g. if you want to build shared libraries or with ODBC support)

#### Windows

<font color="red">
__TODO: section might be out-of-date__
</font>

##### Building GSL

- [download GSL](http://david.geldreich.free.fr/dev.html)
- build using the solution, target debug/release static

##### Building Poco

ODEMx currently only works with shared poco libs. To build them, use the build scripts in the poco source directory.

Example:

- Open the Visual Studio command line
- cd to the directory
- execute buildvs09.cmd # TODO ???
- This will put the poco files into `$pocodir/bin`. You have to copy the dlls manually to your executable which uses odemx!

### Building ODEMx

#### Linux, MacOS, MinGW, Cygwin

- create a build directory in a parent of your ODEMx directory, e.g. `ODEMX_HOME/../build-eclipse-mingw`
- change directory to the created build directory
- __make sure you have CMake__
- generate Makefiles with cmake
    - set variable `INSTALL_PREFIX` to your install directory
    - __NOTE: for debug builds, add `-D CMAKE_BUILD_TYPE=Debug` to your cmake invocation__
    - sample invocations for different generators:
        - Unix
            - `cmake -G "Unix Makefiles" -D CMAKE_BUILD_TYPE=Debug -D INSTALL_PREFIX=../install -D ../odemx`
        - MSYS
            - `cmake -G "MSYS Makefiles" -D CMAKE_BUILD_TYPE=Debug -D INSTALL_PREFIX=../install -D ../odemx`
        - Eclipse CDT4 - MinGW
            - __IMPORTANT: With this generator, cmake must be invoked from a new Windows shell (don't open the Windows shell from MSYS)!__
            - __SEE ALSO:__ [Using Eclipse CDT4 Generator](http://www.vtk.org/Wiki/Eclipse_CDT4_Generator)
            - `cmake -G "Eclipse CDT4 - MinGW Makefiles" -D CMAKE_BUILD_TYPE=Debug -D INSTALL_PREFIX=../install ../odemx`
- run make
- run make install

<!--
#### MinGW in a Windows VM

... that links to external ODEMx sources in the file system of the host.

- open a MinGW shell
- mount your ODEMx directory for easy access in MSYS, e.g. `mount z:/Projekte/odemx /home/Administrator/odemx` (unfortunately cmake cannot follow such mount points)
- create a separate build and install directory (e.g. `ODEMX_HOME/../build-mingw` and `ODEMX_HOME/../install-mingw`)
- build the external libraries (see above), __IMPORTANT: don't forget to clean previous builds first (make clean for each external library)__
- change directory to your created build directory
- run cmake with options like these: `cmake -D INSTALL_PREFIX=../install-mingw -D GSL_INSTALL_PREFIX=../install-mingw -D POCO_INSTALL_PREFIX=../install-mingw -G "MSYS Makefiles" ../odemx`
- make
- make install
-->

#### Customizing Library Paths (optional)

If you want to use custom paths, edit the following variables (NOTE: you can also pass them as command line arguments):

- GSL -- path of libgsl.a
- GSL_INSTALL_PREFIX -- path of the gsl install directory (used to find includes)
    - NOTE: Your path should look similar to install_dir/ where install_dir contains directories like lib/, bin/, etc.
- POCO_DATA -- path of libPocoData.a
- POCO_FOUNDATION -- path of libPocoFoundation.a
- POCO_INSTALL_PREFIX -- path of PoCo install directory (used to find includes)
    - NOTE: Your path should look similar to install_dir/ where install_dir contains directories like lib/, bin/, etc.
- POCO_SQLITE -- path of PocoSqLite.a
- POCO_XML -- path of PocoXML.a
    - NOTE: The cmake files contain hints which try to guess where you placed your libraries. If your libs are placed in POCO_INSTALL_DIR/lib and/or GSL_INSTALL_DIR/lib, then you don't have to set the other variables.

You can pass command line arguments to CMake with `-D` like this: `-D GSL_INSTALL_PREFIX=/your_install_dir`

#### Windows

<font color="red">
__TODO: section might be out-of-date__
</font>

- Create a directory for an out-of-source build (e.g. odemx-build)
- Tell cmake where to find the sources and the build dir (see the description in 3.1). NOTE: You have to define those variables when building for Visual Studio!
- Open the odemx.sln with Visual Studio in your build directory and hit F7.

### Building the ODEMx Documentation (optional)

- cd to a build directory (e.g. `ODEMX_HOME/build`)
- set variables for building the documentation: `cmake -D BUILD_ONLY_DOCUMENTATION=ON -D GENERATE_DOXYGEN=ON ../`
- run `make doc` (this will place HTML files to `ODEMX_HOME/Doxygen`

### Building and Running Tests for ODEMx (optional)

- edit `ODEMX_HOME/CMakeLists.txt`
- `make` (usual make first)
- `make odemxT`
- `make test`

Using ODEMx
===========

Getting Started - Your First ODEMx Project
-------------------------------------------

You can create your first ODEMx project by using files from a sample project in `ODEMX_HOME/SampleProject`. The sample project includes a simple ODEMx program (`main.cpp`) and a `CMakeLists.txt`.

- create a directory for your project
- copy the contents of `ODEMX_HOME/SampleProject` to your own project
- edit `source/CMakeLists.txt`
    - set variable `ODEMX_INSTALL` to the install directory of your ODEMx build
    - for builds under MinGW/MSYS: set variable `MINGW_DIR` to the absolute path of your MinGW home directory, e.g. `C:/MinGW`
- create a build directory in a parent of the source directory, e.g. `ODEMX_HOME/SampleProject/build-eclipse-mingw`
- change directory to the created build directory
- generate Makefiles with cmake
    - __NOTE: for debug builds, add `-D CMAKE_BUILD_TYPE=Debug` to your cmake invocation__
    - sample invocations for different generators:
        - Unix Makefiles
            - `cmake -G "Unix Makefiles" -D CMAKE_BUILD_TYPE=Debug ../source`
        - MSYS Makefiles
            - `cmake -G "MSYS Makefiles" -D CMAKE_BUILD_TYPE=Debug ../source`
        - Eclipse CDT4 - MinGW Makefiles
            - __IMPORTANT: With this generator, cmake must be invoked from a new Windows shell (don't open the Windows shell from MSYS)!__
            - `cmake -G "Eclipse CDT4 - MinGW Makefiles" -D CMAKE_BUILD_TYPE=Debug ../source`
- run make

Using the ODEMx Debugger
========================

Compatibility Notes
-------------------

### Eclipse

- tested with Helios and Indigo

## MinGW

- requires mingw-gdb __version 7.1__ -- __TODO: provide files__

### MacOS X

- not useable

Installation Notes
------------------

- install Eclipse with CDT
- install the ODEMx Debugger Plugin from [this Update Site](https://www2.informatik.hu-berlin.de/sam/lehre/tools/odemx/debugger)

Preparation of ODEMx-based Projects
-----------------------------------

- make sure that you build your ODEMx library with debug symbols (see Building ODEMx)

Debugging a Binary with the ODEMx Debugger
------------------------------------------

- open the debug configuration of the binary execution
- at the bottom of the main tab: click _Select other..._ and choose _Standard Create Process Launcher_
- in the debugger tab:
    - select an appropriate version of the ODEMx Debugger (e.g. _OdemxDebugger (MinGW)_)
    - select your execution platform

GUI Usage
---------

See __TODO: insert link__.

Additional Information
----------------------

See __TODO: insert link to diplomarbeit__.

