/**
 * @file TestDiscreteConst.cpp
 * @date Aug 9, 2008
 * @author Ronald Kluth
 *
 * @brief Tests for ODEMx class DiscreteConst
 */

#include "TestRandom.h"
#include "../TestBase/TestBase.h"

/// @cond DOXYGEN_SKIP
SUITE( Random )
{
/// @endcond

	/**
	 * @struct DiscreteConstFixture
	 * @brief Helper struct providing set-up/tear-down of DiscreteConst tests
	 *
	 * @copydetails EventFixture
	 */
	struct DiscreteConstFixture
	{
		SuiteBase::SimulationTest sim;
		TestLogConsumer::Ptr log;
		int constValue;
		DiscreteConst discreteConst;
		data::TypeInfo type;

		DiscreteConstFixture()
		:	sim( "DiscreteConstTestSim" ),
		 	log( TestLogConsumer::create() ),
			constValue( 7 ),
			discreteConst( sim, "DiscreteConstTest", constValue ),
			type( typeid(DiscreteConst) )
			{
				sim.addConsumer( log );
			}
	};

	/**
	 * @test odemx::DiscreteConst construction
	 *
	 * Expected function call effects:
	 * @li label is set
	 * @li dist context (simulation) is set
	 * @li const value is set
	 */
	TEST_FIXTURE( DiscreteConstFixture, ConstructionDestruction )
	{
		data::Label l = "DiscreteConstTestUserSimConstruction";
		{
			DiscreteConst discreteConst( sim, l, constValue );
			CHECK( log->getTraceRecord( "create", type ) );
			CHECK( log->getStatisticsRecord( "parameter", "seed", type ) );
			CHECK( log->getStatisticsRecord( "parameter", "value", type ) );
			CHECK_EQUAL( l, discreteConst.getLabel() );
			CHECK_EQUAL( constValue, discreteConst.getValue() );
		}
		CHECK( log->getTraceRecord( "destroy", type ) );
	}

	/**
	 * @test odemx::DiscreteConst::sample()
	 *
	 * Expected function call effects:
	 * @li samples equal the const value
	 */
	TEST_FIXTURE( DiscreteConstFixture, Sample )
	{
		CHECK_EQUAL( discreteConst.getValue(), discreteConst.sample() );
		CHECK( log->getTraceRecord( "sample", type ) );
		CHECK( log->getStatisticsRecord( "count", "uses", type ) );
	}

/// @cond DOXYGEN_SKIP
}
/// @endcond
