/**
 * @file TestContinuousDist.cpp
 * @date Aug 9, 2008
 * @author Ronald Kluth
 *
 * @brief Tests for ODEMx class ContinuousDist
 */

#include "TestRandom.h"
#include "../TestBase/TestBase.h"

/// @cond DOXYGEN_SKIP
SUITE( Random )
{
/// @endcond

	/**
	 * @struct ContinuousDistFixture
	 * @brief Helper struct providing set-up/tear-down of ContinuousDist tests
	 *
	 * @copydetails EventFixture
	 */
	struct ContinuousDistFixture
	{
		SuiteBase::SimulationTest sim;
		ContinuousDistTest dist;

		ContinuousDistFixture()
		:	sim( "ContinuousDistTestSim" ),
			dist( sim, "ContinuousDistTest" )
			{}
	};

	/**
	 * @test odemx::ContinuousDist construction
	 *
	 * Expected function call effects:
	 * @li dist context (simulation) is set correctly
	 * @li label is set correctly
	 */
	TEST_FIXTURE( ContinuousDistFixture, ConstructionDestruction )
	{
		data::Label l = "ContinuousDistTestUserSimConstruction";
		ContinuousDistTest dist( sim, l );
		CHECK_EQUAL( l, dist.getLabel() );
	}

/// @cond DOXYGEN_SKIP
}
/// @endcond
