/**
 * @file TestErrorModelDraw.cpp
 * @date May 5, 2010
 * @author ron
 *
 * @brief
 */

#include "TestProtocol.h"
#include "../TestBase/TestBase.h"

/// @cond DOXYGEN_SKIP
SUITE( Protocol )
{
/// @endcond

	TEST( ErrorModelDraw )
	{
		SuiteBase::SimulationTest sim( "ErrorModelDrawTestSim" );
		PduPtr p( new PduTest() );
		ErrorModelPtr em = ErrorModelDraw::create( sim, "ErrorModelDrawTest", 0.5 );
		int resTrue = 0;
		int resFalse = 0;

		int i = 1000000;
		while( i-- )
		{
			if( em->apply( p ) )
			{
				++resTrue;
			}
			else
			{
				++resFalse;
			}
		}

		CHECK_CLOSE( 500000, resTrue, 1000 );
		CHECK_CLOSE( 500000, resFalse, 1000 );
	}

/// @cond DOXYGEN_SKIP
}
/// @endcond
