/**
 * @file TestSimRecordFilterFilter.cpp
 * @date May 3, 2010
 * @author ron
 *
 * @brief
 */

#include "TestData.h"
#include "../TestBase/TestBase.h"

/// @cond DOXYGEN_SKIP
SUITE( Data )
{
/// @endcond

	/**
	 * @struct SimRecordFilterFixture
	 * @brief Helper struct providing set-up/tear-down of SimRecordFilter tests
	 *
	 * @copydetails EventFixture
	 */
	struct SimRecordFilterFixture
	{
		SuiteBase::SimulationTest sim;
		TestLogConsumer::Ptr log;
		ProducerTest producer;
		TypeInfo type;

		SimRecordFilterFixture()
		:	sim( "SimRecordFilterTestSim" )
		,	log( TestLogConsumer::create() )
		,	producer( sim, "SimRecordFilterTestFixtureProducer" )
		,	type( typeid(ProducerTest) )
		{
			sim.addConsumer( log );
		}
	};

	TEST_FIXTURE( SimRecordFilterFixture, Mode )
	{
		SimRecordFilterPtr filter = SimRecordFilter::create();
		producer.info->setFilter( filter );
		filter->passNone();
		StringLiteral msg = "SimRecordFilterTestMode";
		producer.info << producer.log( msg );
		CHECK( ! log->getInfoRecord( msg, TypeInfo() ) );

		filter->passAll();
		producer.info << producer.log( msg );
		CHECK( log->getInfoRecord( msg, TypeInfo() ) );
	}



/// @cond DOXYGEN_SKIP
}
/// @endcond
