/**
 * @file TestManagedChannels.cpp
 * @date May 3, 2010
 * @author ron
 *
 * @brief
 */

#include "TestData.h"
#include "../TestBase/TestBase.h"

#ifdef _MSC_VER
#include <memory>
#else
#include <tr1/memory>
#endif

ODEMX_DECLARE_DATA_CHANNEL_WITH_ID( testManagedChannel, 1024 );

/// @cond DOXYGEN_SKIP
SUITE( Data )
{
/// @endcond


	TEST( ManagedChannelId )
	{
		CHECK_EQUAL( 1024, (int)odemx::data::channel_id::testManagedChannel );
	}

	TEST( ManagedChannelToString )
	{
		CHECK_EQUAL( "trace", odemx::data::channel_id::toString( odemx::data::channel_id::trace ) );
		CHECK_EQUAL( "debug", odemx::data::channel_id::toString( odemx::data::channel_id::debug ) );
		CHECK_EQUAL( "info", odemx::data::channel_id::toString( odemx::data::channel_id::info ) );
		CHECK_EQUAL( "warning", odemx::data::channel_id::toString( odemx::data::channel_id::warning ) );
		CHECK_EQUAL( "error", odemx::data::channel_id::toString( odemx::data::channel_id::error ) );
		CHECK_EQUAL( "fatal", odemx::data::channel_id::toString( odemx::data::channel_id::fatal ) );
		CHECK_EQUAL( "statistics", odemx::data::channel_id::toString( odemx::data::channel_id::statistics ) );
		CHECK_EQUAL( "user-defined", odemx::data::channel_id::toString( 12345678 ) );
	}

/// @cond DOXYGEN_SKIP
}
/// @endcond

