#!/bin/bash
#
# Simple script to produce a C-language structure of whatever
# binary input is sent in.  For example to include a raw image
# directly into the source code of a program.
#

if [ "x$1" = "x" ] ; then set "-"; fi
echo "#ifndef $2_HPP\n#define $2_HPP\nnamespace odemx {\nnamespace resources {\nstruct $2 {\nstatic const char val [];\n};\n}}\n#endif\n" > include/odemx/resources/$2.h

echo "#include <odemx/resources/$2.h>\nconst char odemx::resources::$2::val[] = {" > src/resources/$2.cpp
od -v -tx1 $1 | awk ' \
   BEGIN {} \
   /^[0-9]/     { printf "  "; \
                  for (i=2; i<=NF; i++) printf "0x" $i ", "; \
                  printf "\n"} \
   END {} ' >> src/resources/$2.cpp

echo "};\n" >> src/resources/$2.cpp

