/**
 * @file TestTab.cpp
 * @date Aug 5, 2008
 * @author Ronald Kluth
 *
 * @brief Tests for ODEMx class Tab
 */

#include "TestStatistics.h"
#include "../TestBase/TestBase.h"

/// @cond DOXYGEN_SKIP
SUITE( Statistics )
{
/// @endcond

	/**
	 * @struct TabFixture
	 * @brief Helper struct providing set-up/tear-down of Tab tests
	 *
	 * @copydetails EventFixture
	 */
	struct TabFixture
	{
		SuiteBase::SimulationTest sim;
		TabTest tab;

		TabFixture()
		:	sim( "TabTestSim" ),
			tab( sim, "TabTest" )
			{}
	};

	/**
	 * @test odemx::Tab construction
	 *
	 * Expected effects:
	 * @li label is set correctly
	 * @li statistics manager (Simulation) is set correctly
	 * @li usage count is 0
	 * @li last reset time is current SimTime
	 */
	TEST_FIXTURE( TabFixture, ConstructionDestruction )
	{
		data::Label label = "TestTabConstructionUserSim";
		std::auto_ptr< Tab > tab( new TabTest( sim, label ) );
		CHECK_EQUAL( label, tab->getLabel() );
		CHECK_EQUAL( (unsigned int) 0, tab->getUpdateCount() );
		CHECK_EQUAL( sim.getTime(), tab->getResetTime() );
	}

	/**
	 * @test odemx::Tab::update()
	 *
	 * Expected function call effects:
	 * @li usage counter is increased by one
	 */
	TEST_FIXTURE( TabFixture, Update )
	{
		tab.update();
		CHECK_EQUAL( (std::size_t) 1, tab.getUpdateCount() );
	}

	/**
	 * @test odemx::Tab::reset()
	 *
	 * Expected function call effects:
	 * @li the usage counter is set to 0
	 * @li the last reset time is set to the sim's time
	 */
	TEST_FIXTURE( TabFixture, Reset )
	{
		base::SimTime simTime = 25;
		tab.update();
		tab.update();
		CHECK( tab.getUpdateCount() > 0 );

		tab.reset( simTime );
		CHECK_EQUAL( (std::size_t) 0, tab.getUpdateCount() );
		CHECK_EQUAL( simTime, tab.getResetTime() );
	}

/// @cond DOXYGEN_SKIP
}
/// @endcond
