/**
 * @file TestStatistics.h
 * @date Aug 5, 2008
 * @author Ronald Kluth
 *
 * @brief Contains all helper classes required for testing ODEMx module \b %Statistics.
 */

#ifndef TESTSTATISTICS_H_
#define TESTSTATISTICS_H_

#include <UnitTest++.h>
#include "../Main/Globals.h"

#include <odemx/statistics/Accumulate.h>
#include <odemx/statistics/Count.h>
#include <odemx/statistics/Histogram.h>
#include <odemx/statistics/Regression.h>
#include <odemx/statistics/Sum.h>
#include <odemx/statistics/Tab.h>
#include <odemx/statistics/Tally.h>

#include <memory>

/**
 * @namespace SuiteStatistics
 *
 * @brief Contains helpers and tests for module ODEMx %Statistics
 *
 * The UnitTest++ macro SUITE( Statistics ) declares namespace
 * SuiteStatistics. Consequently, all helpers for this test suite should
 * be placed in the same namespace.
 */

namespace SuiteStatistics {

	using namespace odemx::statistics;
	using namespace std;

	/***************************** Tab ****************************************/

	/**
	 * @class TabTest
	 * @brief Subclass of Tab that makes protected function public for testing
	 */
	class TabTest:
		public Tab
	{
	public:
		/// Constructor for user-defined Simulation
		TabTest( base::Simulation& s, const data::Label& l )
		:	Tab( s, l )
			{}
		/// required implementation of pure virtual ReportProducer interface
		virtual void report( data::Report& report ) {}
	};
}

#endif
