/**
 * @file TestRandom.h
 * @date Aug 8, 2008
 * @author Ronald Kluth
 *
 * @brief Contains all helper classes required for testing ODEMx module \b %Random.
 */

#ifndef TESTRANDOM_H_
#define TESTRANDOM_H_

#include <UnitTest++.h>
#include "../Main/Globals.h"

#include <odemx/data/SimRecordFilter.h>

#include <odemx/random/DistContext.h>
#include <odemx/random/Dist.h>
#include <odemx/random/DiscreteDist.h>
#include <odemx/random/DiscreteConst.h>
#include <odemx/random/ContinuousDist.h>
#include <odemx/random/ContinuousConst.h>
#include <odemx/random/Draw.h>
#include <odemx/random/Erlang.h>
#include <odemx/random/NegativeExponential.h>
#include <odemx/random/Normal.h>
#include <odemx/random/Poisson.h>
#include <odemx/random/RandomInt.h>
#include <odemx/random/Uniform.h>
#include <odemx/statistics/Histogram.h>

/**
 * @namespace Random
 *
 * @brief Contains helpers and tests for module ODEMx %Random
 *
 * The UnitTest++ macro SUITE( Random ) declares namespace
 * Random. Consequently, all helpers for this test suite should
 * be placed in the same namespace.
 */

namespace SuiteRandom {

	using namespace odemx::random;
	using namespace std;

	/***************************** DIST ***************************************/

	/**
	 * @class DistTest
	 * @brief Subclass for making Dist methods public and implementing pure
	 * virtual functions
	 */
	class DistTest:
		public Dist
	{
	public:
		/// Constructor
		DistTest( base::Simulation& dc, const data::Label& l )
		:	Dist( dc, l )
			{}

		/// Makes protected function public for testing
		double getSample()
		{
			return Dist::getSample();
		}
	};

	/*************************** DISCRETE DIST ********************************/

	/**
	 * @class DiscreteDistTest
	 * @brief Subclass that implements required pure virtual functions
	 */
	class DiscreteDistTest:
		public DiscreteDist
	{
	public:
		/// Constructor for user-defined Simulation
		DiscreteDistTest( base::Simulation& dc, const data::Label& l )
		:	DiscreteDist( dc, l )
			{}
		/// Required implementation of pure virtual function
		virtual int sample() { return 1; }
	};

	/************************* CONTINUOUS DIST ********************************/

	/**
	 * @class ContinuousDistTest
	 * @brief Subclass that implements required pure virtual functions
	 */
	class ContinuousDistTest:
		public ContinuousDist
	{
	public:
		/// Constructor for user-defined Simulation
		ContinuousDistTest( base::Simulation& dc, const data::Label& l )
		:	ContinuousDist( dc, l )
			{}
		/// Required implementation of pure virtual function
		virtual double sample() { return 1; }
	};

}

#endif /* TESTRANDOM_H_ */
