/**
 * @file TestOStreamWriter.cpp
 * @date May 3, 2010
 * @author ron
 *
 * @brief
 */

#include "../TestData.h"
#include "../../TestBase/TestBase.h"

/// @cond DOXYGEN_SKIP
SUITE( Data )
{
/// @endcond

	/**
	 * @struct OStreamWriterFixture
	 * @brief Helper struct providing set-up/tear-down of OStreamWriter tests
	 *
	 * @copydetails EventFixture
	 */
	struct OStreamWriterFixture
	{
		SuiteBase::SimulationTest sim;
		std::ostringstream stream;
		ProducerTest producer;
		TypeInfo type;

		OStreamWriterFixture()
		:	sim( "OStreamWriterTestSim" )
		,	stream()
		,	producer( sim, "OStreamWriterTestProducer" )
		,	type( typeid(ProducerTest) )
		{
		}

		~OStreamWriterFixture()
		{
		}
	};

	TEST_FIXTURE( OStreamWriterFixture, Construction )
	{
		OStreamWriterPtr osWriter = OStreamWriter::create( stream );
		CHECK( stream.str().find( "ODEMx Log" ) != std::string::npos );
	}

	TEST_FIXTURE( OStreamWriterFixture, Consume )
	{
		sim.addConsumer( channel_id::info, OStreamWriter::create( stream ) );
		base::SimTime time = 480;
		sim.setCurrentTime( time );
		StringLiteral msg = "OStreamWriterTestConsume";
		StringLiteral detName = "DetailConsume";
		int detVal = 98765;

		producer.info << producer.log( msg ).detail( detName, detVal ).scope( type );
		CHECK( stream.str().find( toString( time ) ) != std::string::npos );
		CHECK( stream.str().find( channel_id::toString( channel_id::info ) ) != std::string::npos );
		CHECK( stream.str().find( producer.getLabel() ) != std::string::npos );
		CHECK( stream.str().find( producer.getType().toString() ) != std::string::npos );
		CHECK( stream.str().find( msg.c_str() ) != std::string::npos );
		CHECK( stream.str().find( detName.c_str() ) != std::string::npos );
		CHECK( stream.str().find( toString( detVal) ) != std::string::npos );
		CHECK( stream.str().find( type.toString() ) != std::string::npos );
	}

	TEST_FIXTURE( OStreamWriterFixture, SetTimeFormat )
	{
		OStreamWriterPtr osWriter = OStreamWriter::create( stream );
		GermanTime* format = new GermanTime( TimeBase( 2010, 5, 3, 21*60+44, TimeUnit::minutes ) );
		osWriter->setTimeFormat( format );
		sim.addConsumer( channel_id::info, osWriter );
		base::SimTime time = 480;
		sim.setCurrentTime( time );
		StringLiteral msg = "OStreamWriterTestSetTimeFormat";

		producer.info << producer.log( msg );
		CHECK( stream.str().find( format->timeToString( time ) ) != std::string::npos );
	}

/// @cond DOXYGEN_SKIP
}
/// @endcond
