/**
 * @file ODEMxUnitTest.cpp
 * @brief Contains implementations of global helper functions and \c main()
 *
 * This file contains implementations of global helper functions and the main
 * function of the whole unit test application.
 */

#include <iostream>
#include <cassert>
using namespace std;

#include <UnitTest++.h>
#include "TestReporterStdout.h"
#include "Globals.h"

ostringstream& errorStream()
{
	static ostringstream errorStream;
	return errorStream;
}

void clearErrorStream()
{
	errorStream().str( "" );
}


/**
 * @brief Starting point of the test project
 *
 * The \c main function first swaps the buffer of \c cerr with that
 * of errorStream(). Then, it simply runs all test suites, which in turn
 * execute all their registered tests.
 *
 * @param argc command line argument counter
 * @param argv command line argument vector
 * @return number of failed tests
 */
int main(int argc, char **argv)
{
	// redirect cerr into an ostringstream by swapping their
	// stream buffers, saving the original buffer for restoration
	streambuf* originalCerrBuffer = cerr.rdbuf( errorStream().rdbuf() );
	assert( originalCerrBuffer );

	cout << "ODEMx Testing started" << endl;
	cout << "=====================" << endl;


	int result = 0;

	// run specific test suites
//	UnitTest::TestReporterStdout reporter;
//	result += UnitTest::RunAllTests( reporter, UnitTest::Test::GetTestList(), "Display", 0 );

	// run all test suites automatically
	result = UnitTest::RunAllTests();

	cout << "======================" << endl;
	cout << "ODEMx Testing finished" << endl;

	// restore the original cerr stream buffer;
	cerr.rdbuf( originalCerrBuffer );
	return result;
}
