
function deleteDir( dirString ) {
	var fso = new ActiveXObject("Scripting.FileSystemObject");

	if ( fso.FolderExists( dirString ) ) {
		fso.DeleteFolder( dirString );
	}
	else {
		WScript.echo( "Cannot delete directory " + dirString );
	}
}

function deleteFile( pattern ) {
	var fso = new ActiveXObject("Scripting.FileSystemObject");

	fso.DeleteFile( pattern );
}


function getFiles( parentDir ) {
	var fso = new ActiveXObject("Scripting.FileSystemObject");
	
	f = fso.GetFolder( parentDir );

	// iterate over collection
	iter = new Enumerator(f.Files);
	s = "";
	for (; !iter.atEnd(); iter.moveNext()) {
		s += fso.GetFileName( iter.item() );
		s += "\n";
	}

	return s;
}

var logString = "Cleaned up:\n";

function cleanUp() 
{
	var fso = new ActiveXObject("Scripting.FileSystemObject");
	
	// use current folder as starting point
	here = fso.GetFolder( "." );

	// iterate over collection
	iter = new Enumerator(here.SubFolders);
	s = "";
	for (; !iter.atEnd(); iter.moveNext()) 
	{
		var current = iter.item();

		// check for Debug directory in current sub dir
		if( fso.FolderExists( current.Name + "\\obj" ) ) 
		{
			// delete the Debug dir
			deleteDir( current.Name + "\\obj" );
			logString += "Directory " + current.Name + "\\obj\n";
		}

		// check for Debug directory in current sub dir
		if( fso.FolderExists( current.Name + "\\Debug" ) ) 
		{
			// delete the Debug dir
			deleteDir( current.Name + "\\Debug" );
			logString += "Directory " + current.Name + "\\Debug\n";
		}

		// check for Release directory in current sub dir
		if( fso.FolderExists( current.Name + "\\Release" ) ) 
		{
			// delete the Debug dir
			deleteDir( current.Name + "\\Release" );
			logString += "Directory " + current.Name + "\\Release\n";
		}

		// iterate over files in current sub dir
		fileList = new Enumerator( current.Files );
		for (; !fileList.atEnd(); fileList.moveNext()) 
		{	
			str = fso.GetFileName( fileList.item() );
			
			// check for various extensions of unnecessary files, which will be recreated by VS automatically
			if( fso.GetExtensionName( fileList.item() ) == "suo"
				|| fso.GetExtensionName( fileList.item() ) == "user"
				|| fso.GetExtensionName( fileList.item() ) == "ncb" ) 
			{
				deleteFile( fileList.item() );
				logString += "File " + str + "\n";
			}
		}
	}
}

cleanUp();
WScript.echo( logString );
