/**
 * @file TestResources.cpp
 * @date Apr 19, 2011
 * @author mamuelle
 * @brief Tests for ODEMx builtin resources (XmlLog.css, etc.). Those resource must be
 * included int the resulting library.
 * */

#include "../Main/Globals.h"

#include <odemx/resources/XmlLog_css.h>
#include <odemx/resources/XmlLog_js.h>
#include <odemx/resources/XmlReport_xsl.h>

#include <fstream>

/// @cond DOXYGEN_SKIP
SUITE( Resources )
{
	using std::ofstream;
	/**
	 * @test Deserializing XmlLog.css by using XmlLog_css.h
	 * */
	TEST( DeserializeXmlLogCss  )
	{
		ofstream xmllogcss( "XmlLog.css", std::ios::out );
		CHECK( xmllogcss.good() );
		xmllogcss << resources::XmlLog_css::val;
		CHECK( !( !xmllogcss ) );
		CHECK( xmllogcss.is_open() );
	}

	/**
	 * @test Deserializing XmlLog.js by using XmlLog_js.h
	 * */
	TEST( DeserializeXmlLogJs )
	{
		ofstream xmllogjs( "XmlLog.js", std::ios::out );
		CHECK( xmllogjs.good() );
		xmllogjs << resources::XmlLog_js::val;
		CHECK( !( !xmllogjs ) );
		CHECK( xmllogjs.is_open() );
	}

	/**
	 * @test Deserializing XmlLog.js by using XmlLog_js.h
	 * */
	TEST( DeserializeXmlReportXsl )
	{
		ofstream xmlreportxsl( "XmlReport.xsl", std::ios::out );
		CHECK( xmlreportxsl.good() );
		xmlreportxsl << resources::XmlReport_xsl::val;
		CHECK( !( !xmlreportxsl ) );
		CHECK( xmlreportxsl.is_open() );
	}
}

/// @endcond
