/**
 * @file TestErrorWriter.cpp
 * @date May 3, 2010
 * @author ron
 *
 * @brief
 */

#include "../TestData.h"
#include "../../TestBase/TestBase.h"

/// @cond DOXYGEN_SKIP
SUITE( Data )
{
/// @endcond

	/**
	 * @struct ErrorWriterFixture
	 * @brief Helper struct providing set-up/tear-down of ErrorWriter tests
	 *
	 * @copydetails EventFixture
	 */
	struct ErrorWriterFixture
	{
		SuiteBase::SimulationTest sim;
		TestLogConsumer::Ptr log;
		ProducerTest producer;
		std::string dbFileName;
		TypeInfo type;

		ErrorWriterFixture()
		:	sim( "ErrorWriterTestSim" )
		,	log( TestLogConsumer::create() )
		,	producer( sim, "ErrorWriterTestFixtureProducer" )
		,	dbFileName( "ErrorWriterTest.db" )
		,	type( typeid(ProducerTest) )
		{
			sim.addConsumer( log );
		}
	};

	TEST_FIXTURE( ErrorWriterFixture, Warning )
	{
		clearErrorStream();
		producer.warning << producer.log( "ErrorWriterTestWarning" ).scope( type );
		CHECK_EQUAL( "ODEMx WARNING: ErrorWriterTestWarning "
				"[Time: 0] [Object: ErrorWriterTestFixtureProducer (SuiteData::ProducerTest)] "
				"[Scope: SuiteData::ProducerTest]\n", errorStream().str() );
	}

	TEST_FIXTURE( ErrorWriterFixture, Error )
	{
		clearErrorStream();
		producer.error << producer.log( "ErrorWriterTestError" ).scope( type );
		CHECK_EQUAL( "ODEMx ERROR: ErrorWriterTestError "
				"[Time: 0] [Object: ErrorWriterTestFixtureProducer (SuiteData::ProducerTest)] "
				"[Scope: SuiteData::ProducerTest]\n", errorStream().str() );
	}

	TEST_FIXTURE( ErrorWriterFixture, Fatal )
	{
		clearErrorStream();
		producer.fatal << producer.log( "ErrorWriterTestFatal" ).scope( type );
		CHECK_EQUAL( "ODEMx FATAL ERROR: ErrorWriterTestFatal "
				"[Time: 0] [Object: ErrorWriterTestFixtureProducer (SuiteData::ProducerTest)] "
				"[Scope: SuiteData::ProducerTest]\n", errorStream().str() );
	}

	TEST_FIXTURE( ErrorWriterFixture, ConsumeError )
	{
		clearErrorStream();
		sim.addConsumer( channel_id::info, ErrorWriter::create() );
		producer.info << producer.log( "ErrorWriterTestConsumerError" );
		CHECK_EQUAL( "ODEMx ERROR: ErrorWriter::consume(): "
				"connected to wrong log channel\n", errorStream().str() );
	}

/// @cond DOXYGEN_SKIP
}
/// @endcond
