/*
 * WaitCondition.cpp
 *
 *  Created on: 22.03.2011
 *      Author: hausding
 */

#include <odemx/simml/WaitCondition.h>
#include <odemx/base/Simulation.h>

namespace odemx {

namespace synchronization {

WaitCondition::WaitCondition(base::Simulation& sim, const data::Label& label,
		std::vector<Monitor*>* monitors, MemoryObserver* obs) :
	monitors(monitors), Memory(sim, label, IMemory::USER_DEFINED, obs) {
	addWaitCondtionAtAll(monitors);
}

WaitCondition::~WaitCondition() {
	removeWaitConditionAtAll();
	if (monitors)
		delete monitors;
	monitors = 0;
}

bool WaitCondition::isAvailable() {
	return (condition(getSimulation().getTime()));
}

void WaitCondition::action() {
	removeWaitConditionAtAll();
	alert();
}

std::vector<Monitor*>* WaitCondition::getMonitors() {
	return monitors;
}

void WaitCondition::addWaitCondition(Monitor* monitor) {
	assert(monitor);
	monitor->addWaitCondition(this);
}

void WaitCondition::addWaitCondtionAtAll(std::vector<Monitor*>* monitors) {
	if (monitors)
		for (std::vector<Monitor*>::iterator it = getMonitors()->begin(); it
				< getMonitors()->end(); it++)
			addWaitCondition(*it);
}

void WaitCondition::removeWaitCondition(Monitor* monitor) {
	assert(monitor);
	monitor->removeWaitCondition(this);
}

void WaitCondition::removeWaitConditionAtAll() {
	if (monitors)
		for (std::vector<Monitor*>::iterator it = getMonitors()->begin(); it
				< getMonitors()->end(); it++)
			removeWaitCondition(*it);
}

}

}
