/*
 * Transition.cpp
 *
 *  Created on: 13.03.2011
 *      Author: hausding
 */

#include <odemx/simml/Transition.h>
#include <odemx/synchronization/Timer.h>

namespace odemx {

namespace simml {

typedef synchronization::ContextWaitCondition<Block,
		std::vector<Transition::ParameterType> > BlockWaitCondition;

Transition::Parameter::Parameter(Transition::ParameterType state,
		Transition::ParameterType transition,
		Transition::ParameterType constraint) :
	std::vector<Transition::ParameterType>(3) {
	at(0) = state;
	at(1) = transition;
	at(2) = constraint;
}

Transition::Transition(base::Simulation& sim, const data::Label& label,
		bool isRelative, base::SimTime time, Parameter* parameter, State target) :
	trigger(new synchronization::Timer(sim, label)), parameter(parameter), target(target) {
	if (isRelative)
		dynamic_cast<synchronization::Timer*> (getTrigger())->setIn(time);
	else
		dynamic_cast<synchronization::Timer*> (getTrigger())->setAt(time);
}

Transition::Transition(base::Simulation& sim, const data::Label& label,
		Block* context, std::vector<synchronization::Monitor*>* monitors,
		Parameter* parameter, State target) :
			trigger(
					new BlockWaitCondition(context,
							StateMachine::contextConstraint, sim, label,
							monitors, parameter)), parameter(parameter),
			target(target) {
}

Transition::Transition(base::Simulation& sim, const data::Label& label,
		Parameter* parameter, State target) :
	trigger(NULL), parameter(parameter), target(target) {
}

Transition::~Transition() {
	if (trigger)
		delete trigger;
	trigger = 0;
	if (parameter)
		delete parameter;
	parameter = 0;
}

Transition::Trigger* Transition::getTrigger() {
	return trigger;
}

Transition::Parameter* Transition::getParameter() {
	return parameter;
}

State Transition::getTarget() {
	return target;
}

}

}
