/*
 * StateMachine.cpp
 *
 *  Created on: 13.01.2011
 *      Author: hausding
 */

#include <odemx/simml/StateMachine.h>

namespace odemx {

namespace simml {

StateMachine::State StateMachine::terminate = NULL;

StateMachine::ContextConstraint StateMachine::contextConstraint =
		&Block::_check;

StateMachine::ContextBehavior StateMachine::contextBehavior = &Block::_run;

StateMachine::StateMachine(Block* context, base::Simulation& sim,
		const data::Label& label, base::ProcessObserver* obs) :
	Behavior(context, sim, label, obs), state(&StateMachine::initial),
			pseudoState(NONE) {
}

StateMachine::~StateMachine() {
	// TODO Auto-generated destructor stub
}

int StateMachine::main() {
	while (getState() != terminate) {
		(this->*(getState()))();
		Transition* transition = fireTransition();
		if (!transition)
			Process::sleep();
		else
			(getContext()->*(contextBehavior))(getTime(),
					transition->getParameter());
		setState(transition->getTarget());
		setPseudoState(NONE);
		deletePossibleTransitions();
	}

	return 0;
}

StateMachine::State StateMachine::getState() {
	return state;
}

StateMachine::PseudoState StateMachine::getPseudoState() {
	return pseudoState;
}

StateMachine::TransitionVector& StateMachine::getPossibleTransitions() {
	return possibleTransitions;
}

void StateMachine::setPseudoState(PseudoState pseudoState) {
	this->pseudoState = pseudoState;
}

void StateMachine::addPossibleTransition(Transition* transition) {
	assert(transition);
	getPossibleTransitions().push_back(transition);
}

void StateMachine::setState(State state) {
	this->state = state;
}

void StateMachine::deletePossibleTransitions() {
	TransitionVector& transitions = getPossibleTransitions();
	for_each(transitions.begin(), transitions.end(), deleteTransition);
	transitions.clear();
}

void StateMachine::deleteTransition(Transition* transition) {
	delete transition;
	transition = NULL;
}

Transition* StateMachine::fireTransition() {
	TriggerVector triggers;
	TransitionVector triggeredTransitions;
	Transition* transitionWithoutTrigger = compareTrigger(
			getPossibleTransitions(), true, triggers, triggeredTransitions);
	if (!triggeredTransitions.empty()) {
		switch (pseudoState) {
		case CHOICE:
			return transitionWithoutTrigger;
		default:
			// completion transition
			if (transitionWithoutTrigger)
				return transitionWithoutTrigger;
			// completion events are discarded
			triggeredTransitions.clear();
			break;
		}
	}
	// Process::wait returns when a transition is triggered or no trigger exists
	while (Process::wait(&triggers)) {
		Transition* transition = compareTrigger(getPossibleTransitions(),
				false, triggers, triggeredTransitions);
		// events are discarded
		triggeredTransitions.clear();
		// return transition with event occurrence and fulfilled guard
		if (transition)
			return transition;
	}

	// no outgoing transition
	return NULL;
}

Transition* StateMachine::compareTrigger(const TransitionVector& transitions,
		bool receiveTrigger, TriggerVector& triggers,
		TransitionVector& triggeredTransitions) {
	for (TransitionVector::const_iterator iter = transitions.begin(); iter
			< transitions.end(); iter++) {
		Transition::Trigger* trigger = (*iter)->getTrigger();
		if (receiveTrigger) {
			if (trigger)
				triggers.push_back(trigger);
			else
				triggeredTransitions.push_back(*iter);
		}
		// get transitions with event occurrence
		else if (trigger)
			if (trigger->isAvailable())
				triggeredTransitions.push_back(*iter);
	}

	// return the first triggered and fulfilled guard transition
	return checkGuards(triggeredTransitions);
}

Transition* StateMachine::checkGuards(const TransitionVector& transitions) const {
	Transition::Parameter parameter(-1, -1, -1);
	for (TransitionVector::const_iterator iter = transitions.begin(); iter
			< transitions.end(); iter++) {
		parameter = Transition::Parameter((*iter)->getParameter()->at(0),
				(*iter)->getParameter()->at(1), 0);
		if ((getContext()->*(contextConstraint))(getTime(), &parameter))
			return (*iter);
	}

	// no guard constraint fulfilled
	return NULL;
}

}

}
