/*
 * Block.cpp
 *
 *  Created on: 09.11.2010
 *      Author: hausding
 */

#include <odemx/simml/Block.h>

namespace odemx {

namespace simml {

Block::Block() :
	classifierBehavior(NULL), owner(NULL) {
}

Block::Block(Behavior* classifierBehavior) :
	classifierBehavior(classifierBehavior), owner(NULL) {
	assert(this->classifierBehavior);
	if (!this->classifierBehavior->getContext())
		this->classifierBehavior->setContext(this);
	classifierBehavior->base::Process::activate();
}

Block::~Block() {
	if (owner)
		setAssociationNULL(owner);
	for_each(referencers.begin(), referencers.end(), setAssociationNULL);
}

Behavior* Block::getClassifierBehavior() {
	return classifierBehavior;
}

void Block::_run(base::SimTime time, const std::vector<long>* cases) {
}

bool Block::_check(base::SimTime time, const std::vector<long>* cases) const {
	return true;
}

void Block::exitSimulation() {
	if (getClassifierBehavior())
		getClassifierBehavior()->getSimulation().exitSimulation();
}

Block** Block::getOwner() {
	return owner;
}

void Block::setOwner(Block** const owner) {
	if (this->owner)
		setAssociationNULL(this->owner);
	this->owner = owner;
}

void Block::setAssociationNULL(Block** const association) {
	setAssociation(association, NULL);
}

void Block::setAssociation(Block** const association, Block* const value) {
	(*association) = value;
}

void Block::addReferencer(Block** const referencer) {
	referencers.push_back(referencer);
}

void Block::removeReferencer(Block** const referencer) {
	referencers.erase(
			remove(referencers.begin(), referencers.end(), referencer),
			referencers.end());
}

}

}
