/*
 * monitoredT_ptr.h
 *
 *  Created on: 09.07.2011
 *      Author: hausding
 */

#ifndef ODEMX_SYNC_MONITOREDT_PTR_INCLUDED
#define ODEMX_SYNC_MONITOREDT_PTR_INCLUDED

#include <odemx/simml/Monitored.h>

namespace odemx {

namespace synchronization {

template<typename T> class monitored_ptr: public Monitored<T> {
public:
	monitored_ptr();
	explicit monitored_ptr(T* const p);
	virtual ~monitored_ptr();

	monitored_ptr<T>& operator=(const T& src);
	monitored_ptr<T>& operator=(const monitored_ptr<T>& src);
	monitored_ptr<T>& operator=(T* const src);

	T* operator->() const;
	T& operator*() const;

	// has to be public for pointer-to-member usage
	// derived class can define:
	//   operator T*() const;
	//   operator T() const;
	T* ptr;
};

}

}

#endif /* ODEMX_SYNC_MONITOREDT_PTR_INCLUDED */
