/*
 * monitoredT_ptr.cpp
 *
 *  Created on: 09.07.2011
 *      Author: hausding
 */

#include <odemx/simml/monitoredT_ptr.h>

namespace odemx {

namespace synchronization {

template<typename T> monitored_ptr<T>::monitored_ptr() :
	ptr(NULL) {
}

template<typename T> monitored_ptr<T>::monitored_ptr(T* const p) :
	ptr(p) {
}

template<typename T> monitored_ptr<T>::~monitored_ptr() {
}

template<typename T> monitored_ptr<T>& monitored_ptr<T>::operator=(const T& src) {
	if (ptr) {
		*ptr = src;
		synchronization::Monitored<T>::operator=(src);
	}
	return *this;
}

template<typename T> monitored_ptr<T>& monitored_ptr<T>::operator=(
		const monitored_ptr<T>& src) {
	if (src.ptr != ptr) {
		ptr = src.ptr;
		synchronization::Monitored<T>::operator=(src);
	}
	return *this;
}

template<typename T> monitored_ptr<T>& monitored_ptr<T>::operator=(T* const src) {
	if (src != ptr) {
		ptr = src;
		synchronization::Monitored<T>::operator=(src);
	}
	return *this;
}

template<typename T> T* monitored_ptr<T>::operator->() const {
	return ptr;
}

template<typename T> T& monitored_ptr<T>::operator*() const {
	return *ptr;
}

}

}
